@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.MongoDBDatabaseResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB MongoDB database resource object
 * @property id Name of the Cosmos DB MongoDB database
 */
public data class MongoDBDatabaseResourceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.MongoDBDatabaseResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.MongoDBDatabaseResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.MongoDBDatabaseResourceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MongoDBDatabaseResourceArgs].
 */
@PulumiTagMarker
public class MongoDBDatabaseResourceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value Name of the Cosmos DB MongoDB database
     */
    @JvmName("usoxaiwncnpftrkq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the Cosmos DB MongoDB database
     */
    @JvmName("ducanavnnwlbiurp")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): MongoDBDatabaseResourceArgs = MongoDBDatabaseResourceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
