@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.PeriodicModeBackupPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The object representing periodic mode backup policy.
 * @property migrationState The object representing the state of the migration between the backup policies.
 * @property periodicModeProperties Configuration values for periodic mode backup
 * @property type Describes the mode of backups.
 * Expected value is 'Periodic'.
 */
public data class PeriodicModeBackupPolicyArgs(
    public val migrationState: Output<BackupPolicyMigrationStateArgs>? = null,
    public val periodicModeProperties: Output<PeriodicModePropertiesArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.PeriodicModeBackupPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.PeriodicModeBackupPolicyArgs =
        com.pulumi.azurenative.documentdb.inputs.PeriodicModeBackupPolicyArgs.builder()
            .migrationState(migrationState?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .periodicModeProperties(
                periodicModeProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PeriodicModeBackupPolicyArgs].
 */
@PulumiTagMarker
public class PeriodicModeBackupPolicyArgsBuilder internal constructor() {
    private var migrationState: Output<BackupPolicyMigrationStateArgs>? = null

    private var periodicModeProperties: Output<PeriodicModePropertiesArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The object representing the state of the migration between the backup policies.
     */
    @JvmName("bgfuyaaiqynbvadc")
    public suspend fun migrationState(`value`: Output<BackupPolicyMigrationStateArgs>) {
        this.migrationState = value
    }

    /**
     * @param value Configuration values for periodic mode backup
     */
    @JvmName("osvimghbgppugsbl")
    public suspend fun periodicModeProperties(`value`: Output<PeriodicModePropertiesArgs>) {
        this.periodicModeProperties = value
    }

    /**
     * @param value Describes the mode of backups.
     * Expected value is 'Periodic'.
     */
    @JvmName("jlcvexljgnqonweu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The object representing the state of the migration between the backup policies.
     */
    @JvmName("amgkeijuayxoeweg")
    public suspend fun migrationState(`value`: BackupPolicyMigrationStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.migrationState = mapped
    }

    /**
     * @param argument The object representing the state of the migration between the backup policies.
     */
    @JvmName("bbwmjygdrbgawbde")
    public suspend
    fun migrationState(argument: suspend BackupPolicyMigrationStateArgsBuilder.() -> Unit) {
        val toBeMapped = BackupPolicyMigrationStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.migrationState = mapped
    }

    /**
     * @param value Configuration values for periodic mode backup
     */
    @JvmName("qujkrcdodthbltwd")
    public suspend fun periodicModeProperties(`value`: PeriodicModePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodicModeProperties = mapped
    }

    /**
     * @param argument Configuration values for periodic mode backup
     */
    @JvmName("nicepkirovrxyuoj")
    public suspend
    fun periodicModeProperties(argument: suspend PeriodicModePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = PeriodicModePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.periodicModeProperties = mapped
    }

    /**
     * @param value Describes the mode of backups.
     * Expected value is 'Periodic'.
     */
    @JvmName("linhxssxuxnpieiq")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): PeriodicModeBackupPolicyArgs = PeriodicModeBackupPolicyArgs(
        migrationState = migrationState,
        periodicModeProperties = periodicModeProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
