@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.SqlStoredProcedureResourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB SQL storedProcedure resource object
 * @property body Body of the Stored Procedure
 * @property id Name of the Cosmos DB SQL storedProcedure
 */
public data class SqlStoredProcedureResourceArgs(
    public val body: Output<String>? = null,
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.SqlStoredProcedureResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.SqlStoredProcedureResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.SqlStoredProcedureResourceArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SqlStoredProcedureResourceArgs].
 */
@PulumiTagMarker
public class SqlStoredProcedureResourceArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var id: Output<String>? = null

    /**
     * @param value Body of the Stored Procedure
     */
    @JvmName("juvfuceoannfiixy")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Name of the Cosmos DB SQL storedProcedure
     */
    @JvmName("muqjllieeewqwmxk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Body of the Stored Procedure
     */
    @JvmName("jfxhwxuygcmxrknb")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Name of the Cosmos DB SQL storedProcedure
     */
    @JvmName("xswchnvchfmxykkc")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): SqlStoredProcedureResourceArgs = SqlStoredProcedureResourceArgs(
        body = body,
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
