@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.inputs

import com.pulumi.azurenative.documentdb.inputs.SqlTriggerResourceArgs.builder
import com.pulumi.azurenative.documentdb.kotlin.enums.TriggerOperation
import com.pulumi.azurenative.documentdb.kotlin.enums.TriggerType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cosmos DB SQL trigger resource object
 * @property body Body of the Trigger
 * @property id Name of the Cosmos DB SQL trigger
 * @property triggerOperation The operation the trigger is associated with
 * @property triggerType Type of the Trigger
 */
public data class SqlTriggerResourceArgs(
    public val body: Output<String>? = null,
    public val id: Output<String>,
    public val triggerOperation: Output<Either<String, TriggerOperation>>? = null,
    public val triggerType: Output<Either<String, TriggerType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.documentdb.inputs.SqlTriggerResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.documentdb.inputs.SqlTriggerResourceArgs =
        com.pulumi.azurenative.documentdb.inputs.SqlTriggerResourceArgs.builder()
            .body(body?.applyValue({ args0 -> args0 }))
            .id(id.applyValue({ args0 -> args0 }))
            .triggerOperation(
                triggerOperation?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .triggerType(
                triggerType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SqlTriggerResourceArgs].
 */
@PulumiTagMarker
public class SqlTriggerResourceArgsBuilder internal constructor() {
    private var body: Output<String>? = null

    private var id: Output<String>? = null

    private var triggerOperation: Output<Either<String, TriggerOperation>>? = null

    private var triggerType: Output<Either<String, TriggerType>>? = null

    /**
     * @param value Body of the Trigger
     */
    @JvmName("cdeapbdbnkkqudnh")
    public suspend fun body(`value`: Output<String>) {
        this.body = value
    }

    /**
     * @param value Name of the Cosmos DB SQL trigger
     */
    @JvmName("eatwwdglbqdpcorl")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The operation the trigger is associated with
     */
    @JvmName("fynihblvmhuubrxq")
    public suspend fun triggerOperation(`value`: Output<Either<String, TriggerOperation>>) {
        this.triggerOperation = value
    }

    /**
     * @param value Type of the Trigger
     */
    @JvmName("timlnlrbhnahlsis")
    public suspend fun triggerType(`value`: Output<Either<String, TriggerType>>) {
        this.triggerType = value
    }

    /**
     * @param value Body of the Trigger
     */
    @JvmName("iakjjocjqdgmsiit")
    public suspend fun body(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.body = mapped
    }

    /**
     * @param value Name of the Cosmos DB SQL trigger
     */
    @JvmName("cycslgnidugjvbpp")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The operation the trigger is associated with
     */
    @JvmName("dvhonhwqmhqaoxut")
    public suspend fun triggerOperation(`value`: Either<String, TriggerOperation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerOperation = mapped
    }

    /**
     * @param value The operation the trigger is associated with
     */
    @JvmName("ayxfngkembmewhho")
    public fun triggerOperation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerOperation = mapped
    }

    /**
     * @param value The operation the trigger is associated with
     */
    @JvmName("ilxsdnttbeadkgoj")
    public fun triggerOperation(`value`: TriggerOperation) {
        val toBeMapped = Either.ofRight<String, TriggerOperation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerOperation = mapped
    }

    /**
     * @param value Type of the Trigger
     */
    @JvmName("euppugjuureouyuu")
    public suspend fun triggerType(`value`: Either<String, TriggerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value Type of the Trigger
     */
    @JvmName("ooftwjgbwsneigol")
    public fun triggerType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    /**
     * @param value Type of the Trigger
     */
    @JvmName("aitakmphdrsmxgtb")
    public fun triggerType(`value`: TriggerType) {
        val toBeMapped = Either.ofRight<String, TriggerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.triggerType = mapped
    }

    internal fun build(): SqlTriggerResourceArgs = SqlTriggerResourceArgs(
        body = body,
        id = id ?: throw PulumiNullFieldException("id"),
        triggerOperation = triggerOperation,
        triggerType = triggerType,
    )
}
