@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property additionalErrorInfo Additional information about the error.
 * @property code The code of error that occurred.
 * @property message The message of the error.
 * @property target The target resource of the error.
 */
public data class CassandraErrorResponse(
    public val additionalErrorInfo: String? = null,
    public val code: String? = null,
    public val message: String? = null,
    public val target: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CassandraErrorResponse):
            CassandraErrorResponse = CassandraErrorResponse(
            additionalErrorInfo = javaType.additionalErrorInfo().map({ args0 -> args0 }).orElse(null),
            code = javaType.code().map({ args0 -> args0 }).orElse(null),
            message = javaType.message().map({ args0 -> args0 }).orElse(null),
            target = javaType.target().map({ args0 -> args0 }).orElse(null),
        )
    }
}
