@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Cosmos DB Cassandra table partition key
 * @property name Name of the Cosmos DB Cassandra table partition key
 */
public data class CassandraPartitionKeyResponse(
    public val name: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CassandraPartitionKeyResponse):
            CassandraPartitionKeyResponse = CassandraPartitionKeyResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
        )
    }
}
