@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property analyticalStorageTtl Analytical TTL.
 * @property defaultTtl Time to live of the Cosmos DB Cassandra table
 * @property etag A system generated property representing the resource etag required for optimistic concurrency control.
 * @property id Name of the Cosmos DB Cassandra table
 * @property rid A system generated property. A unique identifier.
 * @property schema Schema of the Cosmos DB Cassandra table
 * @property ts A system generated property that denotes the last updated timestamp of the resource.
 */
public data class CassandraTableGetPropertiesResponseResource(
    public val analyticalStorageTtl: Int? = null,
    public val defaultTtl: Int? = null,
    public val etag: String,
    public val id: String,
    public val rid: String,
    public val schema: CassandraSchemaResponse? = null,
    public val ts: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CassandraTableGetPropertiesResponseResource):
            CassandraTableGetPropertiesResponseResource = CassandraTableGetPropertiesResponseResource(
            analyticalStorageTtl = javaType.analyticalStorageTtl().map({ args0 -> args0 }).orElse(null),
            defaultTtl = javaType.defaultTtl().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            rid = javaType.rid(),
            schema = javaType.schema().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraSchemaResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ts = javaType.ts(),
        )
    }
}
