@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property autoscaleSettings Specifies the Autoscale settings.
 * @property throughput Value of the Cosmos DB resource throughput or autoscaleSettings. Use the ThroughputSetting resource when retrieving offer details.
 */
public data class CassandraViewGetPropertiesResponseOptions(
    public val autoscaleSettings: AutoscaleSettingsResponse? = null,
    public val throughput: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.CassandraViewGetPropertiesResponseOptions):
            CassandraViewGetPropertiesResponseOptions = CassandraViewGetPropertiesResponseOptions(
            autoscaleSettings = javaType.autoscaleSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.AutoscaleSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            throughput = javaType.throughput().map({ args0 -> args0 }).orElse(null),
        )
    }
}
