@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of a managed Cassandra cluster.
 * @property authenticationMethod Which authentication method Cassandra should use to authenticate clients. 'None' turns off authentication, so should not be used except in emergencies. 'Cassandra' is the default password based authentication. The default is 'Cassandra'.
 * @property cassandraAuditLoggingEnabled Whether Cassandra audit logging is enabled
 * @property cassandraVersion Which version of Cassandra should this cluster converge to running (e.g., 3.11). When updated, the cluster may take some time to migrate to the new version.
 * @property clientCertificates List of TLS certificates used to authorize clients connecting to the cluster. All connections are TLS encrypted whether clientCertificates is set or not, but if clientCertificates is set, the managed Cassandra cluster will reject all connections not bearing a TLS client certificate that can be validated from one or more of the public certificates in this property.
 * @property clusterNameOverride If you need to set the clusterName property in cassandra.yaml to something besides the resource name of the cluster, set the value to use on this property.
 * @property deallocated Whether the cluster and associated data centers has been deallocated.
 * @property delegatedManagementSubnetId Resource id of a subnet that this cluster's management service should have its network interface attached to. The subnet must be routable to all subnets that will be delegated to data centers. The resource id must be of the form '/subscriptions/<subscription id>/resourceGroups/<resource group>/providers/Microsoft.Network/virtualNetworks/<virtual network>/subnets/<subnet>'
 * @property externalGossipCertificates List of TLS certificates used to authorize gossip from unmanaged data centers. The TLS certificates of all nodes in unmanaged data centers must be verifiable using one of the certificates provided in this property.
 * @property externalSeedNodes List of IP addresses of seed nodes in unmanaged data centers. These will be added to the seed node lists of all managed nodes.
 * @property gossipCertificates List of TLS certificates that unmanaged nodes must trust for gossip with managed nodes. All managed nodes will present TLS client certificates that are verifiable using one of the certificates provided in this property.
 * @property hoursBetweenBackups (Deprecated) Number of hours to wait between taking a backup of the cluster.
 * @property prometheusEndpoint Hostname or IP address where the Prometheus endpoint containing data about the managed Cassandra nodes can be reached.
 * @property provisionError Error related to resource provisioning.
 * @property provisioningState The status of the resource at the time the operation was called.
 * @property repairEnabled Should automatic repairs run on this cluster? If omitted, this is true, and should stay true unless you are running a hybrid cluster where you are already doing your own repairs.
 * @property seedNodes List of IP addresses of seed nodes in the managed data centers. These should be added to the seed node lists of all unmanaged nodes.
 */
public data class ClusterResourceResponseProperties(
    public val authenticationMethod: String? = null,
    public val cassandraAuditLoggingEnabled: Boolean? = null,
    public val cassandraVersion: String? = null,
    public val clientCertificates: List<CertificateResponse>? = null,
    public val clusterNameOverride: String? = null,
    public val deallocated: Boolean? = null,
    public val delegatedManagementSubnetId: String? = null,
    public val externalGossipCertificates: List<CertificateResponse>? = null,
    public val externalSeedNodes: List<SeedNodeResponse>? = null,
    public val gossipCertificates: List<CertificateResponse>,
    public val hoursBetweenBackups: Int? = null,
    public val prometheusEndpoint: SeedNodeResponse? = null,
    public val provisionError: CassandraErrorResponse? = null,
    public val provisioningState: String? = null,
    public val repairEnabled: Boolean? = null,
    public val seedNodes: List<SeedNodeResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ClusterResourceResponseProperties):
            ClusterResourceResponseProperties = ClusterResourceResponseProperties(
            authenticationMethod = javaType.authenticationMethod().map({ args0 -> args0 }).orElse(null),
            cassandraAuditLoggingEnabled = javaType.cassandraAuditLoggingEnabled().map({ args0 ->
                args0
            }).orElse(null),
            cassandraVersion = javaType.cassandraVersion().map({ args0 -> args0 }).orElse(null),
            clientCertificates = javaType.clientCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CertificateResponse.Companion.toKotlin(args0)
                })
            }),
            clusterNameOverride = javaType.clusterNameOverride().map({ args0 -> args0 }).orElse(null),
            deallocated = javaType.deallocated().map({ args0 -> args0 }).orElse(null),
            delegatedManagementSubnetId = javaType.delegatedManagementSubnetId().map({ args0 ->
                args0
            }).orElse(null),
            externalGossipCertificates = javaType.externalGossipCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CertificateResponse.Companion.toKotlin(args0)
                })
            }),
            externalSeedNodes = javaType.externalSeedNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.SeedNodeResponse.Companion.toKotlin(args0)
                })
            }),
            gossipCertificates = javaType.gossipCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CertificateResponse.Companion.toKotlin(args0)
                })
            }),
            hoursBetweenBackups = javaType.hoursBetweenBackups().map({ args0 -> args0 }).orElse(null),
            prometheusEndpoint = javaType.prometheusEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.SeedNodeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisionError = javaType.provisionError().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.CassandraErrorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            repairEnabled = javaType.repairEnabled().map({ args0 -> args0 }).orElse(null),
            seedNodes = javaType.seedNodes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.SeedNodeResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
