@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Connection string for the mongo cluster
 * @property connectionString Value of the connection string
 * @property description Description of the connection string
 */
public data class ConnectionStringResponse(
    public val connectionString: String,
    public val description: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ConnectionStringResponse):
            ConnectionStringResponse = ConnectionStringResponse(
            connectionString = javaType.connectionString(),
            description = javaType.description(),
        )
    }
}
