@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A notebook workspace resource
 * @property id The unique resource identifier of the database account.
 * @property name The name of the database account.
 * @property notebookServerEndpoint Specifies the endpoint of Notebook server.
 * @property status Status of the notebook workspace. Possible values are: Creating, Online, Deleting, Failed, Updating.
 * @property type The type of Azure resource.
 */
public data class GetNotebookWorkspaceResult(
    public val id: String,
    public val name: String,
    public val notebookServerEndpoint: String,
    public val status: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.GetNotebookWorkspaceResult):
            GetNotebookWorkspaceResult = GetNotebookWorkspaceResult(
            id = javaType.id(),
            name = javaType.name(),
            notebookServerEndpoint = javaType.notebookServerEndpoint(),
            status = javaType.status(),
            type = javaType.type(),
        )
    }
}
