@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Cosmos DB indexing policy
 * @property automatic Indicates if the indexing policy is automatic
 * @property compositeIndexes List of composite path list
 * @property excludedPaths List of paths to exclude from indexing
 * @property includedPaths List of paths to include in the indexing
 * @property indexingMode Indicates the indexing mode.
 * @property spatialIndexes List of spatial specifics
 */
public data class IndexingPolicyResponse(
    public val automatic: Boolean? = null,
    public val compositeIndexes: List<List<CompositePathResponse>>? = null,
    public val excludedPaths: List<ExcludedPathResponse>? = null,
    public val includedPaths: List<IncludedPathResponse>? = null,
    public val indexingMode: String? = null,
    public val spatialIndexes: List<SpatialSpecResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.IndexingPolicyResponse):
            IndexingPolicyResponse = IndexingPolicyResponse(
            automatic = javaType.automatic().map({ args0 -> args0 }).orElse(null),
            compositeIndexes = javaType.compositeIndexes().map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.documentdb.kotlin.outputs.CompositePathResponse.Companion.toKotlin(args0)
                    })
                })
            }),
            excludedPaths = javaType.excludedPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.ExcludedPathResponse.Companion.toKotlin(args0)
                })
            }),
            includedPaths = javaType.includedPaths().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.IncludedPathResponse.Companion.toKotlin(args0)
                })
            }),
            indexingMode = javaType.indexingMode().map({ args0 -> args0 }).orElse(null),
            spatialIndexes = javaType.spatialIndexes().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.SpatialSpecResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
