@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The connection strings for the given database account.
 * @property connectionStrings An array that contains the connection strings for the Cosmos DB account.
 */
public data class ListDatabaseAccountConnectionStringsResult(
    public val connectionStrings: List<DatabaseAccountConnectionStringResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ListDatabaseAccountConnectionStringsResult):
            ListDatabaseAccountConnectionStringsResult = ListDatabaseAccountConnectionStringsResult(
            connectionStrings = javaType.connectionStrings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.DatabaseAccountConnectionStringResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
