@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The access keys for the given database account.
 * @property primaryMasterKey Base 64 encoded value of the primary read-write key.
 * @property primaryReadonlyMasterKey Base 64 encoded value of the primary read-only key.
 * @property secondaryMasterKey Base 64 encoded value of the secondary read-write key.
 * @property secondaryReadonlyMasterKey Base 64 encoded value of the secondary read-only key.
 */
public data class ListDatabaseAccountKeysResult(
    public val primaryMasterKey: String,
    public val primaryReadonlyMasterKey: String,
    public val secondaryMasterKey: String,
    public val secondaryReadonlyMasterKey: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.ListDatabaseAccountKeysResult):
            ListDatabaseAccountKeysResult = ListDatabaseAccountKeysResult(
            primaryMasterKey = javaType.primaryMasterKey(),
            primaryReadonlyMasterKey = javaType.primaryReadonlyMasterKey(),
            secondaryMasterKey = javaType.secondaryMasterKey(),
            secondaryReadonlyMasterKey = javaType.secondaryReadonlyMasterKey(),
        )
    }
}
