@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A region in which the Azure Cosmos DB database account is deployed.
 * @property documentEndpoint The connection endpoint for the specific region. Example: https://&lt;accountName&gt;-&lt;locationName&gt;.documents.azure.com:443/
 * @property failoverPriority The failover priority of the region. A failover priority of 0 indicates a write region. The maximum value for a failover priority = (total number of regions - 1). Failover priority values must be unique for each of the regions in which the database account exists.
 * @property id The unique identifier of the region within the database account. Example: &lt;accountName&gt;-&lt;locationName&gt;.
 * @property isZoneRedundant Flag to indicate whether or not this region is an AvailabilityZone region
 * @property locationName The name of the region.
 * @property provisioningState The status of the Cosmos DB account at the time the operation was called. The status can be one of following. 'Creating' – the Cosmos DB account is being created. When an account is in Creating state, only properties that are specified as input for the Create Cosmos DB account operation are returned. 'Succeeded' – the Cosmos DB account is active for use. 'Updating' – the Cosmos DB account is being updated. 'Deleting' – the Cosmos DB account is being deleted. 'Failed' – the Cosmos DB account failed creation. 'DeletionFailed' – the Cosmos DB account deletion failed.
 */
public data class LocationResponse(
    public val documentEndpoint: String,
    public val failoverPriority: Int? = null,
    public val id: String,
    public val isZoneRedundant: Boolean? = null,
    public val locationName: String? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.LocationResponse):
            LocationResponse = LocationResponse(
            documentEndpoint = javaType.documentEndpoint(),
            failoverPriority = javaType.failoverPriority().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isZoneRedundant = javaType.isZoneRedundant().map({ args0 -> args0 }).orElse(null),
            locationName = javaType.locationName().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
        )
    }
}
