@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Resource for a regional service location.
 * @property location The location name.
 * @property name The regional service name.
 * @property status Describes the status of a service.
 */
public data class MaterializedViewsBuilderRegionalServiceResourceResponse(
    public val location: String,
    public val name: String,
    public val status: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.MaterializedViewsBuilderRegionalServiceResourceResponse):
            MaterializedViewsBuilderRegionalServiceResourceResponse =
            MaterializedViewsBuilderRegionalServiceResourceResponse(
                location = javaType.location(),
                name = javaType.name(),
                status = javaType.status(),
            )
    }
}
