@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The object representing periodic mode backup policy.
 * @property migrationState The object representing the state of the migration between the backup policies.
 * @property periodicModeProperties Configuration values for periodic mode backup
 * @property type Describes the mode of backups.
 * Expected value is 'Periodic'.
 */
public data class PeriodicModeBackupPolicyResponse(
    public val migrationState: BackupPolicyMigrationStateResponse? = null,
    public val periodicModeProperties: PeriodicModePropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.PeriodicModeBackupPolicyResponse):
            PeriodicModeBackupPolicyResponse = PeriodicModeBackupPolicyResponse(
            migrationState = javaType.migrationState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.BackupPolicyMigrationStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            periodicModeProperties = javaType.periodicModeProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.PeriodicModePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
