@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.documentdb.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Parameters to indicate the information about the restore.
 * @property databasesToRestore List of specific databases available for restore.
 * @property gremlinDatabasesToRestore List of specific gremlin databases available for restore.
 * @property restoreMode Describes the mode of the restore.
 * @property restoreSource The id of the restorable database account from which the restore has to be initiated. For example: /subscriptions/{subscriptionId}/providers/Microsoft.DocumentDB/locations/{location}/restorableDatabaseAccounts/{restorableDatabaseAccountName}
 * @property restoreTimestampInUtc Time to which the account has to be restored (ISO-8601 format).
 * @property tablesToRestore List of specific tables available for restore.
 */
public data class RestoreParametersResponse(
    public val databasesToRestore: List<DatabaseRestoreResourceResponse>? = null,
    public val gremlinDatabasesToRestore: List<GremlinDatabaseRestoreResourceResponse>? = null,
    public val restoreMode: String? = null,
    public val restoreSource: String? = null,
    public val restoreTimestampInUtc: String? = null,
    public val tablesToRestore: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.documentdb.outputs.RestoreParametersResponse):
            RestoreParametersResponse = RestoreParametersResponse(
            databasesToRestore = javaType.databasesToRestore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.DatabaseRestoreResourceResponse.Companion.toKotlin(args0)
                })
            }),
            gremlinDatabasesToRestore = javaType.gremlinDatabasesToRestore().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.documentdb.kotlin.outputs.GremlinDatabaseRestoreResourceResponse.Companion.toKotlin(args0)
                })
            }),
            restoreMode = javaType.restoreMode().map({ args0 -> args0 }).orElse(null),
            restoreSource = javaType.restoreSource().map({ args0 -> args0 }).orElse(null),
            restoreTimestampInUtc = javaType.restoreTimestampInUtc().map({ args0 -> args0 }).orElse(null),
            tablesToRestore = javaType.tablesToRestore().map({ args0 -> args0 }),
        )
    }
}
