@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin

import com.pulumi.azurenative.domainregistration.kotlin.outputs.HostNameResponse
import com.pulumi.azurenative.domainregistration.kotlin.outputs.HostNameResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Domain].
 */
@PulumiTagMarker
public class DomainResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DomainArgs = DomainArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DomainArgsBuilder.() -> Unit) {
        val builder = DomainArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Domain {
        val builtJavaResource =
            com.pulumi.azurenative.domainregistration.Domain(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Domain(builtJavaResource)
    }
}

/**
 * Information about a domain.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2020-10-01.
 * Other available API versions: 2020-10-01, 2023-01-01.
 * ## Example Usage
 * ### Create App Service Domain
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var domain = new AzureNative.DomainRegistration.Domain("domain", new()
 *     {
 *         AuthCode = "exampleAuthCode",
 *         AutoRenew = true,
 *         Consent = new AzureNative.DomainRegistration.Inputs.DomainPurchaseConsentArgs
 *         {
 *             AgreedAt = "2021-09-10T19:30:53Z",
 *             AgreedBy = "192.0.2.1",
 *             AgreementKeys = new[]
 *             {
 *                 "agreementKey1",
 *             },
 *         },
 *         ContactAdmin = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "admin@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Admin",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         ContactBilling = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "billing@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Billing",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         ContactRegistrant = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "registrant@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Registrant",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         ContactTech = new AzureNative.DomainRegistration.Inputs.ContactArgs
 *         {
 *             AddressMailing = new AzureNative.DomainRegistration.Inputs.AddressArgs
 *             {
 *                 Address1 = "3400 State St",
 *                 City = "Chicago",
 *                 Country = "United States",
 *                 PostalCode = "67098",
 *                 State = "IL",
 *             },
 *             Email = "tech@email.com",
 *             Fax = "1-245-534-2242",
 *             JobTitle = "Tech",
 *             NameFirst = "John",
 *             NameLast = "Doe",
 *             NameMiddle = "",
 *             Organization = "Microsoft Inc.",
 *             Phone = "1-245-534-2242",
 *         },
 *         DnsType = AzureNative.DomainRegistration.DnsType.DefaultDomainRegistrarDns,
 *         DomainName = "example.com",
 *         Location = "global",
 *         Privacy = false,
 *         ResourceGroupName = "testrg123",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/domainregistration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := domainregistration.NewDomain(ctx, "domain", &domainregistration.DomainArgs{
 * 			AuthCode:  pulumi.String("exampleAuthCode"),
 * 			AutoRenew: pulumi.Bool(true),
 * 			Consent: &domainregistration.DomainPurchaseConsentArgs{
 * 				AgreedAt: pulumi.String("2021-09-10T19:30:53Z"),
 * 				AgreedBy: pulumi.String("192.0.2.1"),
 * 				AgreementKeys: pulumi.StringArray{
 * 					pulumi.String("agreementKey1"),
 * 				},
 * 			},
 * 			ContactAdmin: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("admin@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Admin"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			ContactBilling: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("billing@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Billing"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			ContactRegistrant: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("registrant@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Registrant"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			ContactTech: &domainregistration.ContactArgs{
 * 				AddressMailing: &domainregistration.AddressArgs{
 * 					Address1:   pulumi.String("3400 State St"),
 * 					City:       pulumi.String("Chicago"),
 * 					Country:    pulumi.String("United States"),
 * 					PostalCode: pulumi.String("67098"),
 * 					State:      pulumi.String("IL"),
 * 				},
 * 				Email:        pulumi.String("tech@email.com"),
 * 				Fax:          pulumi.String("1-245-534-2242"),
 * 				JobTitle:     pulumi.String("Tech"),
 * 				NameFirst:    pulumi.String("John"),
 * 				NameLast:     pulumi.String("Doe"),
 * 				NameMiddle:   pulumi.String(""),
 * 				Organization: pulumi.String("Microsoft Inc."),
 * 				Phone:        pulumi.String("1-245-534-2242"),
 * 			},
 * 			DnsType:           domainregistration.DnsTypeDefaultDomainRegistrarDns,
 * 			DomainName:        pulumi.String("example.com"),
 * 			Location:          pulumi.String("global"),
 * 			Privacy:           pulumi.Bool(false),
 * 			ResourceGroupName: pulumi.String("testrg123"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.domainregistration.Domain;
 * import com.pulumi.azurenative.domainregistration.DomainArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var domain = new Domain("domain", DomainArgs.builder()
 *             .authCode("exampleAuthCode")
 *             .autoRenew(true)
 *             .consent(Map.ofEntries(
 *                 Map.entry("agreedAt", "2021-09-10T19:30:53Z"),
 *                 Map.entry("agreedBy", "192.0.2.1"),
 *                 Map.entry("agreementKeys", "agreementKey1")
 *             ))
 *             .contactAdmin(Map.ofEntries(
 *                 Map.entry("addressMailing", Map.ofEntries(
 *                     Map.entry("address1", "3400 State St"),
 *                     Map.entry("city", "Chicago"),
 *                     Map.entry("country", "United States"),
 *                     Map.entry("postalCode", "67098"),
 *                     Map.entry("state", "IL")
 *                 )),
 *                 Map.entry("email", "admin@email.com"),
 *                 Map.entry("fax", "1-245-534-2242"),
 *                 Map.entry("jobTitle", "Admin"),
 *                 Map.entry("nameFirst", "John"),
 *                 Map.entry("nameLast", "Doe"),
 *                 Map.entry("nameMiddle", ""),
 *                 Map.entry("organization", "Microsoft Inc."),
 *                 Map.entry("phone", "1-245-534-2242")
 *             ))
 *             .contactBilling(Map.ofEntries(
 *                 Map.entry("addressMailing", Map.ofEntries(
 *                     Map.entry("address1", "3400 State St"),
 *                     Map.entry("city", "Chicago"),
 *                     Map.entry("country", "United States"),
 *                     Map.entry("postalCode", "67098"),
 *                     Map.entry("state", "IL")
 *                 )),
 *                 Map.entry("email", "billing@email.com"),
 *                 Map.entry("fax", "1-245-534-2242"),
 *                 Map.entry("jobTitle", "Billing"),
 *                 Map.entry("nameFirst", "John"),
 *                 Map.entry("nameLast", "Doe"),
 *                 Map.entry("nameMiddle", ""),
 *                 Map.entry("organization", "Microsoft Inc."),
 *                 Map.entry("phone", "1-245-534-2242")
 *             ))
 *             .contactRegistrant(Map.ofEntries(
 *                 Map.entry("addressMailing", Map.ofEntries(
 *                     Map.entry("address1", "3400 State St"),
 *                     Map.entry("city", "Chicago"),
 *                     Map.entry("country", "United States"),
 *                     Map.entry("postalCode", "67098"),
 *                     Map.entry("state", "IL")
 *                 )),
 *                 Map.entry("email", "registrant@email.com"),
 *                 Map.entry("fax", "1-245-534-2242"),
 *                 Map.entry("jobTitle", "Registrant"),
 *                 Map.entry("nameFirst", "John"),
 *                 Map.entry("nameLast", "Doe"),
 *                 Map.entry("nameMiddle", ""),
 *                 Map.entry("organization", "Microsoft Inc."),
 *                 Map.entry("phone", "1-245-534-2242")
 *             ))
 *             .contactTech(Map.ofEntries(
 *                 Map.entry("addressMailing", Map.ofEntries(
 *                     Map.entry("address1", "3400 State St"),
 *                     Map.entry("city", "Chicago"),
 *                     Map.entry("country", "United States"),
 *                     Map.entry("postalCode", "67098"),
 *                     Map.entry("state", "IL")
 *                 )),
 *                 Map.entry("email", "tech@email.com"),
 *                 Map.entry("fax", "1-245-534-2242"),
 *                 Map.entry("jobTitle", "Tech"),
 *                 Map.entry("nameFirst", "John"),
 *                 Map.entry("nameLast", "Doe"),
 *                 Map.entry("nameMiddle", ""),
 *                 Map.entry("organization", "Microsoft Inc."),
 *                 Map.entry("phone", "1-245-534-2242")
 *             ))
 *             .dnsType("DefaultDomainRegistrarDns")
 *             .domainName("example.com")
 *             .location("global")
 *             .privacy(false)
 *             .resourceGroupName("testrg123")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:domainregistration:Domain example.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DomainRegistration/domains/{domainName}
 * ```
 */
public class Domain internal constructor(
    override val javaResource: com.pulumi.azurenative.domainregistration.Domain,
) : KotlinCustomResource(javaResource, DomainMapper) {
    public val authCode: Output<String>?
        get() = javaResource.authCode().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * <code>true</code> if the domain should be automatically renewed; otherwise, <code>false</code>.
     */
    public val autoRenew: Output<Boolean>?
        get() = javaResource.autoRenew().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Domain creation timestamp.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Current DNS type
     */
    public val dnsType: Output<String>?
        get() = javaResource.dnsType().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure DNS Zone to use
     */
    public val dnsZoneId: Output<String>?
        get() = javaResource.dnsZoneId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Reasons why domain is not renewable.
     */
    public val domainNotRenewableReasons: Output<List<String>>
        get() = javaResource.domainNotRenewableReasons().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * Domain expiration timestamp.
     */
    public val expirationTime: Output<String>
        get() = javaResource.expirationTime().applyValue({ args0 -> args0 })

    /**
     * Kind of resource.
     */
    public val kind: Output<String>?
        get() = javaResource.kind().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Timestamp when the domain was renewed last time.
     */
    public val lastRenewedTime: Output<String>
        get() = javaResource.lastRenewedTime().applyValue({ args0 -> args0 })

    /**
     * Resource Location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * All hostnames derived from the domain and assigned to Azure resources.
     */
    public val managedHostNames: Output<List<HostNameResponse>>
        get() = javaResource.managedHostNames().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Resource Name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Name servers.
     */
    public val nameServers: Output<List<String>>
        get() = javaResource.nameServers().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * <code>true</code> if domain privacy is enabled for this domain; otherwise, <code>false</code>.
     */
    public val privacy: Output<Boolean>?
        get() = javaResource.privacy().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Domain provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * <code>true</code> if Azure can assign this domain to App Service apps; otherwise, <code>false</code>. This value will be <code>true</code> if domain registration status is active and
     *  it is hosted on name servers Azure has programmatic access to.
     */
    public val readyForDnsRecordManagement: Output<Boolean>
        get() = javaResource.readyForDnsRecordManagement().applyValue({ args0 -> args0 })

    /**
     * Domain registration status.
     */
    public val registrationStatus: Output<String>
        get() = javaResource.registrationStatus().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Target DNS type (would be used for migration)
     */
    public val targetDnsType: Output<String>?
        get() = javaResource.targetDnsType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DomainMapper : ResourceMapper<Domain> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.domainregistration.Domain::class == javaResource::class

    override fun map(javaResource: Resource): Domain = Domain(
        javaResource as
            com.pulumi.azurenative.domainregistration.Domain,
    )
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Domain].
 */
public suspend fun domain(name: String, block: suspend DomainResourceBuilder.() -> Unit): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Domain].
 * @param name The _unique_ name of the resulting resource.
 */
public fun domain(name: String): Domain {
    val builder = DomainResourceBuilder()
    builder.name(name)
    return builder.build()
}
