@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.domainregistration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Target DNS type (would be used for migration)
 */
public enum class DnsType(
    public val javaValue: com.pulumi.azurenative.domainregistration.enums.DnsType,
) : ConvertibleToJava<com.pulumi.azurenative.domainregistration.enums.DnsType> {
    AzureDns(com.pulumi.azurenative.domainregistration.enums.DnsType.AzureDns),
    DefaultDomainRegistrarDns(com.pulumi.azurenative.domainregistration.enums.DnsType.DefaultDomainRegistrarDns),
    ;

    override fun toJava(): com.pulumi.azurenative.domainregistration.enums.DnsType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.domainregistration.enums.DnsType): DnsType =
            DnsType.values().first { it.javaValue == javaType }
    }
}
