@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dynamics365fraudprotection.kotlin.inputs

import com.pulumi.azurenative.dynamics365fraudprotection.inputs.DFPInstanceAdministratorsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * An array of administrator user identities
 * @property members An array of administrator user identities.
 */
public data class DFPInstanceAdministratorsArgs(
    public val members: Output<List<String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.dynamics365fraudprotection.inputs.DFPInstanceAdministratorsArgs> {
    override fun toJava():
        com.pulumi.azurenative.dynamics365fraudprotection.inputs.DFPInstanceAdministratorsArgs =
        com.pulumi.azurenative.dynamics365fraudprotection.inputs.DFPInstanceAdministratorsArgs.builder()
            .members(members?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DFPInstanceAdministratorsArgs].
 */
@PulumiTagMarker
public class DFPInstanceAdministratorsArgsBuilder internal constructor() {
    private var members: Output<List<String>>? = null

    /**
     * @param value An array of administrator user identities.
     */
    @JvmName("esaiylynghvwfqof")
    public suspend fun members(`value`: Output<List<String>>) {
        this.members = value
    }

    @JvmName("qhxfjrxoysthbpok")
    public suspend fun members(vararg values: Output<String>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values An array of administrator user identities.
     */
    @JvmName("tvhdeavnlpapwtqx")
    public suspend fun members(values: List<Output<String>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value An array of administrator user identities.
     */
    @JvmName("pywhpxgyypivxeqn")
    public suspend fun members(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param values An array of administrator user identities.
     */
    @JvmName("ncmhqnetgxxerrqh")
    public suspend fun members(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    internal fun build(): DFPInstanceAdministratorsArgs = DFPInstanceAdministratorsArgs(
        members = members,
    )
}
