@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.easm.kotlin

import com.pulumi.azurenative.easm.EasmFunctions.getLabelByWorkspacePlain
import com.pulumi.azurenative.easm.EasmFunctions.getWorkspacePlain
import com.pulumi.azurenative.easm.kotlin.inputs.GetLabelByWorkspacePlainArgs
import com.pulumi.azurenative.easm.kotlin.inputs.GetLabelByWorkspacePlainArgsBuilder
import com.pulumi.azurenative.easm.kotlin.inputs.GetWorkspacePlainArgs
import com.pulumi.azurenative.easm.kotlin.inputs.GetWorkspacePlainArgsBuilder
import com.pulumi.azurenative.easm.kotlin.outputs.GetLabelByWorkspaceResult
import com.pulumi.azurenative.easm.kotlin.outputs.GetWorkspaceResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.easm.kotlin.outputs.GetLabelByWorkspaceResult.Companion.toKotlin as getLabelByWorkspaceResultToKotlin
import com.pulumi.azurenative.easm.kotlin.outputs.GetWorkspaceResult.Companion.toKotlin as getWorkspaceResultToKotlin

public object EasmFunctions {
    /**
     * Returns a label in the given workspace.
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return Label details
     */
    public suspend fun getLabelByWorkspace(argument: GetLabelByWorkspacePlainArgs):
        GetLabelByWorkspaceResult =
        getLabelByWorkspaceResultToKotlin(getLabelByWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getLabelByWorkspace].
     * @param labelName The name of the Label.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the Workspace.
     * @return Label details
     */
    public suspend fun getLabelByWorkspace(
        labelName: String,
        resourceGroupName: String,
        workspaceName: String,
    ): GetLabelByWorkspaceResult {
        val argument = GetLabelByWorkspacePlainArgs(
            labelName = labelName,
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getLabelByWorkspaceResultToKotlin(getLabelByWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getLabelByWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;easm&#46;kotlin&#46;inputs&#46;GetLabelByWorkspacePlainArgs].
     * @return Label details
     */
    public suspend
    fun getLabelByWorkspace(argument: suspend GetLabelByWorkspacePlainArgsBuilder.() -> Unit):
        GetLabelByWorkspaceResult {
        val builder = GetLabelByWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLabelByWorkspaceResultToKotlin(getLabelByWorkspacePlain(builtArgument.toJava()).await())
    }

    /**
     * Returns a workspace with the given name.
     * Azure REST API version: 2023-04-01-preview.
     * @param argument null
     * @return Workspace details.
     */
    public suspend fun getWorkspace(argument: GetWorkspacePlainArgs): GetWorkspaceResult =
        getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())

    /**
     * @see [getWorkspace].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param workspaceName The name of the Workspace.
     * @return Workspace details.
     */
    public suspend fun getWorkspace(resourceGroupName: String, workspaceName: String):
        GetWorkspaceResult {
        val argument = GetWorkspacePlainArgs(
            resourceGroupName = resourceGroupName,
            workspaceName = workspaceName,
        )
        return getWorkspaceResultToKotlin(getWorkspacePlain(argument.toJava()).await())
    }

    /**
     * @see [getWorkspace].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;easm&#46;kotlin&#46;inputs&#46;GetWorkspacePlainArgs].
     * @return Workspace details.
     */
    public suspend fun getWorkspace(argument: suspend GetWorkspacePlainArgsBuilder.() -> Unit):
        GetWorkspaceResult {
        val builder = GetWorkspacePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getWorkspaceResultToKotlin(getWorkspacePlain(builtArgument.toJava()).await())
    }
}
