@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.easm.kotlin

import com.pulumi.azurenative.easm.LabelByWorkspaceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Label details
 * Azure REST API version: 2023-04-01-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * ## Example Usage
 * ### Labels
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var labelByWorkspace = new AzureNative.Easm.LabelByWorkspace("labelByWorkspace", new()
 *     {
 *         LabelName = "ThisisaLabel",
 *         ResourceGroupName = "dummyrg",
 *         WorkspaceName = "ThisisaWorkspace",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/easm/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := easm.NewLabelByWorkspace(ctx, "labelByWorkspace", &easm.LabelByWorkspaceArgs{
 * 			LabelName:         pulumi.String("ThisisaLabel"),
 * 			ResourceGroupName: pulumi.String("dummyrg"),
 * 			WorkspaceName:     pulumi.String("ThisisaWorkspace"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.easm.LabelByWorkspace;
 * import com.pulumi.azurenative.easm.LabelByWorkspaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var labelByWorkspace = new LabelByWorkspace("labelByWorkspace", LabelByWorkspaceArgs.builder()
 *             .labelName("ThisisaLabel")
 *             .resourceGroupName("dummyrg")
 *             .workspaceName("ThisisaWorkspace")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:easm:LabelByWorkspace ThisisaLabel /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Easm/workspaces/{workspaceName}/labels/{labelName}
 * ```
 * @property color Label color.
 * @property displayName Label display name.
 * @property labelName The name of the Label.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property workspaceName The name of the Workspace.
 */
public data class LabelByWorkspaceArgs(
    public val color: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val labelName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val workspaceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.easm.LabelByWorkspaceArgs> {
    override fun toJava(): com.pulumi.azurenative.easm.LabelByWorkspaceArgs =
        com.pulumi.azurenative.easm.LabelByWorkspaceArgs.builder()
            .color(color?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .labelName(labelName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .workspaceName(workspaceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LabelByWorkspaceArgs].
 */
@PulumiTagMarker
public class LabelByWorkspaceArgsBuilder internal constructor() {
    private var color: Output<String>? = null

    private var displayName: Output<String>? = null

    private var labelName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var workspaceName: Output<String>? = null

    /**
     * @param value Label color.
     */
    @JvmName("uxwqfyeqldnrypga")
    public suspend fun color(`value`: Output<String>) {
        this.color = value
    }

    /**
     * @param value Label display name.
     */
    @JvmName("untenidqkglcdpnh")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The name of the Label.
     */
    @JvmName("dpvxjeopllyinqqr")
    public suspend fun labelName(`value`: Output<String>) {
        this.labelName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jjrxllcihfqiayda")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Workspace.
     */
    @JvmName("pnvyvqvgtgitddyj")
    public suspend fun workspaceName(`value`: Output<String>) {
        this.workspaceName = value
    }

    /**
     * @param value Label color.
     */
    @JvmName("nggxpodllhhgrfdt")
    public suspend fun color(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.color = mapped
    }

    /**
     * @param value Label display name.
     */
    @JvmName("hokwbcdgufecdive")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The name of the Label.
     */
    @JvmName("bvdlytpdibyvtwlu")
    public suspend fun labelName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labelName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bmqbtycghsvxynas")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Workspace.
     */
    @JvmName("bwfoymfcheweukfw")
    public suspend fun workspaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceName = mapped
    }

    internal fun build(): LabelByWorkspaceArgs = LabelByWorkspaceArgs(
        color = color,
        displayName = displayName,
        labelName = labelName,
        resourceGroupName = resourceGroupName,
        workspaceName = workspaceName,
    )
}
