@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin

import com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressDetailsResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.OrderItemDetailsResponse
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.edgeorder.kotlin.outputs.AddressDetailsResponse.Companion.toKotlin as addressDetailsResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.OrderItemDetailsResponse.Companion.toKotlin as orderItemDetailsResponseToKotlin
import com.pulumi.azurenative.edgeorder.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [OrderItem].
 */
@PulumiTagMarker
public class OrderItemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrderItemArgs = OrderItemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrderItemArgsBuilder.() -> Unit) {
        val builder = OrderItemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrderItem {
        val builtJavaResource = com.pulumi.azurenative.edgeorder.OrderItem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrderItem(builtJavaResource)
    }
}

/**
 * Represents order item resource.
 * Azure REST API version: 2022-05-01-preview.
 * Other available API versions: 2024-02-01.
 * ## Example Usage
 * ### CreateOrderItem
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var orderItem = new AzureNative.EdgeOrder.OrderItem("orderItem", new()
 *     {
 *         AddressDetails = new AzureNative.EdgeOrder.Inputs.AddressDetailsArgs
 *         {
 *             ForwardAddress = new AzureNative.EdgeOrder.Inputs.AddressPropertiesArgs
 *             {
 *                 ContactDetails = new AzureNative.EdgeOrder.Inputs.ContactDetailsArgs
 *                 {
 *                     ContactName = "XXXX XXXX",
 *                     EmailList = new[]
 *                     {
 *                         "xxxx@xxxx.xxx",
 *                     },
 *                     Phone = "0000000000",
 *                     PhoneExtension = "",
 *                 },
 *                 ShippingAddress = new AzureNative.EdgeOrder.Inputs.ShippingAddressArgs
 *                 {
 *                     AddressType = "None",
 *                     City = "San Francisco",
 *                     CompanyName = "Microsoft",
 *                     Country = "US",
 *                     PostalCode = "94107",
 *                     StateOrProvince = "CA",
 *                     StreetAddress1 = "16 TOWNSEND ST",
 *                     StreetAddress2 = "UNIT 1",
 *                 },
 *             },
 *         },
 *         Location = "eastus",
 *         OrderId = "/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2",
 *         OrderItemDetails = new AzureNative.EdgeOrder.Inputs.OrderItemDetailsArgs
 *         {
 *             OrderItemType = "Purchase",
 *             Preferences = new AzureNative.EdgeOrder.Inputs.PreferencesArgs
 *             {
 *                 TransportPreferences = new AzureNative.EdgeOrder.Inputs.TransportPreferencesArgs
 *                 {
 *                     PreferredShipmentType = "MicrosoftManaged",
 *                 },
 *             },
 *             ProductDetails = new AzureNative.EdgeOrder.Inputs.ProductDetailsArgs
 *             {
 *                 HierarchyInformation = new AzureNative.EdgeOrder.Inputs.HierarchyInformationArgs
 *                 {
 *                     ConfigurationName = "edgep_base",
 *                     ProductFamilyName = "azurestackedge",
 *                     ProductLineName = "azurestackedge",
 *                     ProductName = "azurestackedgegpu",
 *                 },
 *             },
 *         },
 *         OrderItemName = "TestOrderItemName2",
 *         ResourceGroupName = "YourResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/edgeorder/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := edgeorder.NewOrderItem(ctx, "orderItem", &edgeorder.OrderItemArgs{
 * AddressDetails: edgeorder.AddressDetailsResponse{
 * ForwardAddress: interface{}{
 * ContactDetails: &edgeorder.ContactDetailsArgs{
 * ContactName: pulumi.String("XXXX XXXX"),
 * EmailList: pulumi.StringArray{
 * pulumi.String("xxxx@xxxx.xxx"),
 * },
 * Phone: pulumi.String("0000000000"),
 * PhoneExtension: pulumi.String(""),
 * },
 * ShippingAddress: &edgeorder.ShippingAddressArgs{
 * AddressType: pulumi.String("None"),
 * City: pulumi.String("San Francisco"),
 * CompanyName: pulumi.String("Microsoft"),
 * Country: pulumi.String("US"),
 * PostalCode: pulumi.String("94107"),
 * StateOrProvince: pulumi.String("CA"),
 * StreetAddress1: pulumi.String("16 TOWNSEND ST"),
 * StreetAddress2: pulumi.String("UNIT 1"),
 * },
 * },
 * },
 * Location: pulumi.String("eastus"),
 * OrderId: pulumi.String("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2"),
 * OrderItemDetails: edgeorder.OrderItemDetailsResponse{
 * OrderItemType: pulumi.String("Purchase"),
 * Preferences: interface{}{
 * TransportPreferences: &edgeorder.TransportPreferencesArgs{
 * PreferredShipmentType: pulumi.String("MicrosoftManaged"),
 * },
 * },
 * ProductDetails: interface{}{
 * HierarchyInformation: &edgeorder.HierarchyInformationArgs{
 * ConfigurationName: pulumi.String("edgep_base"),
 * ProductFamilyName: pulumi.String("azurestackedge"),
 * ProductLineName: pulumi.String("azurestackedge"),
 * ProductName: pulumi.String("azurestackedgegpu"),
 * },
 * },
 * },
 * OrderItemName: pulumi.String("TestOrderItemName2"),
 * ResourceGroupName: pulumi.String("YourResourceGroupName"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.edgeorder.OrderItem;
 * import com.pulumi.azurenative.edgeorder.OrderItemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var orderItem = new OrderItem("orderItem", OrderItemArgs.builder()
 *             .addressDetails(Map.of("forwardAddress", Map.ofEntries(
 *                 Map.entry("contactDetails", Map.ofEntries(
 *                     Map.entry("contactName", "XXXX XXXX"),
 *                     Map.entry("emailList", "xxxx@xxxx.xxx"),
 *                     Map.entry("phone", "0000000000"),
 *                     Map.entry("phoneExtension", "")
 *                 )),
 *                 Map.entry("shippingAddress", Map.ofEntries(
 *                     Map.entry("addressType", "None"),
 *                     Map.entry("city", "San Francisco"),
 *                     Map.entry("companyName", "Microsoft"),
 *                     Map.entry("country", "US"),
 *                     Map.entry("postalCode", "94107"),
 *                     Map.entry("stateOrProvince", "CA"),
 *                     Map.entry("streetAddress1", "16 TOWNSEND ST"),
 *                     Map.entry("streetAddress2", "UNIT 1")
 *                 ))
 *             )))
 *             .location("eastus")
 *             .orderId("/subscriptions/YourSubscriptionId/resourceGroups/YourResourceGroupName/providers/Microsoft.EdgeOrder/locations/eastus/orders/TestOrderName2")
 *             .orderItemDetails(Map.ofEntries(
 *                 Map.entry("orderItemType", "Purchase"),
 *                 Map.entry("preferences", Map.of("transportPreferences", Map.of("preferredShipmentType", "MicrosoftManaged"))),
 *                 Map.entry("productDetails", Map.of("hierarchyInformation", Map.ofEntries(
 *                     Map.entry("configurationName", "edgep_base"),
 *                     Map.entry("productFamilyName", "azurestackedge"),
 *                     Map.entry("productLineName", "azurestackedge"),
 *                     Map.entry("productName", "azurestackedgegpu")
 *                 )))
 *             ))
 *             .orderItemName("TestOrderItemName2")
 *             .resourceGroupName("YourResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:edgeorder:OrderItem TestOrderItemName2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EdgeOrder/orderItems/{orderItemName}
 * ```
 */
public class OrderItem internal constructor(
    override val javaResource: com.pulumi.azurenative.edgeorder.OrderItem,
) : KotlinCustomResource(javaResource, OrderItemMapper) {
    /**
     * Represents shipping and return address for order item.
     */
    public val addressDetails: Output<AddressDetailsResponse>
        get() = javaResource.addressDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                addressDetailsResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Id of the order to which order item belongs to.
     */
    public val orderId: Output<String>
        get() = javaResource.orderId().applyValue({ args0 -> args0 })

    /**
     * Represents order item details.
     */
    public val orderItemDetails: Output<OrderItemDetailsResponse>
        get() = javaResource.orderItemDetails().applyValue({ args0 ->
            args0.let({ args0 ->
                orderItemDetailsResponseToKotlin(args0)
            })
        })

    /**
     * Start time of order item.
     */
    public val startTime: Output<String>
        get() = javaResource.startTime().applyValue({ args0 -> args0 })

    /**
     * Represents resource creation and update time.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OrderItemMapper : ResourceMapper<OrderItem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.edgeorder.OrderItem::class == javaResource::class

    override fun map(javaResource: Resource): OrderItem = OrderItem(
        javaResource as
            com.pulumi.azurenative.edgeorder.OrderItem,
    )
}

/**
 * @see [OrderItem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrderItem].
 */
public suspend fun orderItem(name: String, block: suspend OrderItemResourceBuilder.() -> Unit):
    OrderItem {
    val builder = OrderItemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrderItem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun orderItem(name: String): OrderItem {
    val builder = OrderItemResourceBuilder()
    builder.name(name)
    return builder.build()
}
