@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.AddressDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Address details for an order item.
 * @property forwardAddress Customer address and contact details. It should be address resource
 */
public data class AddressDetailsArgs(
    public val forwardAddress: Output<AddressPropertiesArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.AddressDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.AddressDetailsArgs =
        com.pulumi.azurenative.edgeorder.inputs.AddressDetailsArgs.builder()
            .forwardAddress(
                forwardAddress.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AddressDetailsArgs].
 */
@PulumiTagMarker
public class AddressDetailsArgsBuilder internal constructor() {
    private var forwardAddress: Output<AddressPropertiesArgs>? = null

    /**
     * @param value Customer address and contact details. It should be address resource
     */
    @JvmName("aowstnavfyoyitre")
    public suspend fun forwardAddress(`value`: Output<AddressPropertiesArgs>) {
        this.forwardAddress = value
    }

    /**
     * @param value Customer address and contact details. It should be address resource
     */
    @JvmName("cksgsdyyrveiuibk")
    public suspend fun forwardAddress(`value`: AddressPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.forwardAddress = mapped
    }

    /**
     * @param argument Customer address and contact details. It should be address resource
     */
    @JvmName("fwujcgutiycmvdlq")
    public suspend fun forwardAddress(argument: suspend AddressPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AddressPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.forwardAddress = mapped
    }

    internal fun build(): AddressDetailsArgs = AddressDetailsArgs(
        forwardAddress = forwardAddress ?: throw PulumiNullFieldException("forwardAddress"),
    )
}
