@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Configuration filters.
 * @property childConfigurationFilter Filter to fetch specific child configurations that exist in the configuration. This must be passed to either fetch a list of specific child configurations, or all child configurations of specific types of child configurations.
 * @property filterableProperty Filters specific to product.
 * @property hierarchyInformation Product hierarchy information.
 */
public data class ConfigurationFilter(
    public val childConfigurationFilter: ChildConfigurationFilter? = null,
    public val filterableProperty: List<FilterableProperty>? = null,
    public val hierarchyInformation: HierarchyInformation,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilter> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilter =
        com.pulumi.azurenative.edgeorder.inputs.ConfigurationFilter.builder()
            .childConfigurationFilter(
                childConfigurationFilter?.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filterableProperty(
                filterableProperty?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .hierarchyInformation(
                hierarchyInformation.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConfigurationFilter].
 */
@PulumiTagMarker
public class ConfigurationFilterBuilder internal constructor() {
    private var childConfigurationFilter: ChildConfigurationFilter? = null

    private var filterableProperty: List<FilterableProperty>? = null

    private var hierarchyInformation: HierarchyInformation? = null

    /**
     * @param value Filter to fetch specific child configurations that exist in the configuration. This must be passed to either fetch a list of specific child configurations, or all child configurations of specific types of child configurations.
     */
    @JvmName("hikeigdbmbunshiv")
    public suspend fun childConfigurationFilter(`value`: ChildConfigurationFilter?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.childConfigurationFilter = mapped
    }

    /**
     * @param argument Filter to fetch specific child configurations that exist in the configuration. This must be passed to either fetch a list of specific child configurations, or all child configurations of specific types of child configurations.
     */
    @JvmName("tymtgfhmfogxamky")
    public suspend
    fun childConfigurationFilter(argument: suspend ChildConfigurationFilterBuilder.() -> Unit) {
        val toBeMapped = ChildConfigurationFilterBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.childConfigurationFilter = mapped
    }

    /**
     * @param value Filters specific to product.
     */
    @JvmName("suaadoqtftiystop")
    public suspend fun filterableProperty(`value`: List<FilterableProperty>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filterableProperty = mapped
    }

    /**
     * @param argument Filters specific to product.
     */
    @JvmName("emecmubtsdefbvfs")
    public suspend
    fun filterableProperty(argument: List<suspend FilterablePropertyBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FilterablePropertyBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filterableProperty = mapped
    }

    /**
     * @param argument Filters specific to product.
     */
    @JvmName("sjtnhyrerpbspuio")
    public suspend fun filterableProperty(
        vararg
        argument: suspend FilterablePropertyBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FilterablePropertyBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filterableProperty = mapped
    }

    /**
     * @param argument Filters specific to product.
     */
    @JvmName("mspquvvmraustlpw")
    public suspend fun filterableProperty(argument: suspend FilterablePropertyBuilder.() -> Unit) {
        val toBeMapped = listOf(FilterablePropertyBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filterableProperty = mapped
    }

    /**
     * @param values Filters specific to product.
     */
    @JvmName("lpmkfuutrcnoegao")
    public suspend fun filterableProperty(vararg values: FilterableProperty) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filterableProperty = mapped
    }

    /**
     * @param value Product hierarchy information.
     */
    @JvmName("prowacuwtmxfaook")
    public suspend fun hierarchyInformation(`value`: HierarchyInformation) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hierarchyInformation = mapped
    }

    /**
     * @param argument Product hierarchy information.
     */
    @JvmName("ofiwcdqsvlekoerb")
    public suspend
    fun hierarchyInformation(argument: suspend HierarchyInformationBuilder.() -> Unit) {
        val toBeMapped = HierarchyInformationBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.hierarchyInformation = mapped
    }

    internal fun build(): ConfigurationFilter = ConfigurationFilter(
        childConfigurationFilter = childConfigurationFilter,
        filterableProperty = filterableProperty,
        hierarchyInformation = hierarchyInformation ?: throw
            PulumiNullFieldException("hierarchyInformation"),
    )
}
