@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionRegisteredFeatures.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents subscription registered features.
 * @property name Name of subscription registered feature.
 * @property state State of subscription registered feature.
 */
public data class CustomerSubscriptionRegisteredFeatures(
    public val name: String? = null,
    public val state: String? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionRegisteredFeatures> {
    override fun toJava():
        com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionRegisteredFeatures =
        com.pulumi.azurenative.edgeorder.inputs.CustomerSubscriptionRegisteredFeatures.builder()
            .name(name?.let({ args0 -> args0 }))
            .state(state?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomerSubscriptionRegisteredFeatures].
 */
@PulumiTagMarker
public class CustomerSubscriptionRegisteredFeaturesBuilder internal constructor() {
    private var name: String? = null

    private var state: String? = null

    /**
     * @param value Name of subscription registered feature.
     */
    @JvmName("yditwogbaowagies")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value State of subscription registered feature.
     */
    @JvmName("tmmhttmnnrqkatgc")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.state = mapped
    }

    internal fun build(): CustomerSubscriptionRegisteredFeatures =
        CustomerSubscriptionRegisteredFeatures(
            name = name,
            state = state,
        )
}
