@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.ListConfigurationsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property configurationFilters Holds details about product hierarchy information and filterable property.
 * @property customerSubscriptionDetails Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
 * @property skipToken $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
 */
public data class ListConfigurationsPlainArgs(
    public val configurationFilters: List<ConfigurationFilters>,
    public val customerSubscriptionDetails: CustomerSubscriptionDetails? = null,
    public val skipToken: String? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.ListConfigurationsPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.ListConfigurationsPlainArgs =
        com.pulumi.azurenative.edgeorder.inputs.ListConfigurationsPlainArgs.builder()
            .configurationFilters(
                configurationFilters.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .customerSubscriptionDetails(
                customerSubscriptionDetails?.let({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .skipToken(skipToken?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListConfigurationsPlainArgs].
 */
@PulumiTagMarker
public class ListConfigurationsPlainArgsBuilder internal constructor() {
    private var configurationFilters: List<ConfigurationFilters>? = null

    private var customerSubscriptionDetails: CustomerSubscriptionDetails? = null

    private var skipToken: String? = null

    /**
     * @param value Holds details about product hierarchy information and filterable property.
     */
    @JvmName("xctayebgqlooejfm")
    public suspend fun configurationFilters(`value`: List<ConfigurationFilters>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationFilters = mapped
    }

    /**
     * @param argument Holds details about product hierarchy information and filterable property.
     */
    @JvmName("ywaljccexfhivrmr")
    public suspend
    fun configurationFilters(argument: List<suspend ConfigurationFiltersBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ConfigurationFiltersBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.configurationFilters = mapped
    }

    /**
     * @param argument Holds details about product hierarchy information and filterable property.
     */
    @JvmName("dlctfwtctuohelpx")
    public suspend fun configurationFilters(
        vararg
        argument: suspend ConfigurationFiltersBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ConfigurationFiltersBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.configurationFilters = mapped
    }

    /**
     * @param argument Holds details about product hierarchy information and filterable property.
     */
    @JvmName("yqlqavmqmynmkliw")
    public suspend
    fun configurationFilters(argument: suspend ConfigurationFiltersBuilder.() -> Unit) {
        val toBeMapped = listOf(ConfigurationFiltersBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.configurationFilters = mapped
    }

    /**
     * @param values Holds details about product hierarchy information and filterable property.
     */
    @JvmName("tqoyeykwvhbqncve")
    public suspend fun configurationFilters(vararg values: ConfigurationFilters) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationFilters = mapped
    }

    /**
     * @param value Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
     */
    @JvmName("dsybjivwqtayfwhp")
    public suspend fun customerSubscriptionDetails(`value`: CustomerSubscriptionDetails?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.customerSubscriptionDetails = mapped
    }

    /**
     * @param argument Customer subscription properties. Clients can display available products to unregistered customers by explicitly passing subscription details
     */
    @JvmName("bblphldkanccreau")
    public suspend
    fun customerSubscriptionDetails(argument: suspend CustomerSubscriptionDetailsBuilder.() -> Unit) {
        val toBeMapped = CustomerSubscriptionDetailsBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.customerSubscriptionDetails = mapped
    }

    /**
     * @param value $skipToken is supported on list of configurations, which provides the next page in the list of configurations.
     */
    @JvmName("ipmoukitwxuwtrdn")
    public suspend fun skipToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.skipToken = mapped
    }

    internal fun build(): ListConfigurationsPlainArgs = ListConfigurationsPlainArgs(
        configurationFilters = configurationFilters ?: throw
            PulumiNullFieldException("configurationFilters"),
        customerSubscriptionDetails = customerSubscriptionDetails,
        skipToken = skipToken,
    )
}
