@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.NotificationPreferenceArgs.builder
import com.pulumi.azurenative.edgeorder.kotlin.enums.NotificationStageName
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Notification preference for a job stage.
 * @property sendNotification Notification is required or not.
 * @property stageName Name of the stage.
 */
public data class NotificationPreferenceArgs(
    public val sendNotification: Output<Boolean>,
    public val stageName: Output<Either<String, NotificationStageName>>,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.NotificationPreferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.NotificationPreferenceArgs =
        com.pulumi.azurenative.edgeorder.inputs.NotificationPreferenceArgs.builder()
            .sendNotification(sendNotification.applyValue({ args0 -> args0 }))
            .stageName(
                stageName.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [NotificationPreferenceArgs].
 */
@PulumiTagMarker
public class NotificationPreferenceArgsBuilder internal constructor() {
    private var sendNotification: Output<Boolean>? = null

    private var stageName: Output<Either<String, NotificationStageName>>? = null

    /**
     * @param value Notification is required or not.
     */
    @JvmName("uuwijubfyukxmbgk")
    public suspend fun sendNotification(`value`: Output<Boolean>) {
        this.sendNotification = value
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("xlpiivkdmeqtfgeb")
    public suspend fun stageName(`value`: Output<Either<String, NotificationStageName>>) {
        this.stageName = value
    }

    /**
     * @param value Notification is required or not.
     */
    @JvmName("qadjlbxofhahmpbi")
    public suspend fun sendNotification(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sendNotification = mapped
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("hwhjargicwrayhwh")
    public suspend fun stageName(`value`: Either<String, NotificationStageName>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("owfkurxfmktqvbry")
    public fun stageName(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotificationStageName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    /**
     * @param value Name of the stage.
     */
    @JvmName("bdkdyvuqigqvbisf")
    public fun stageName(`value`: NotificationStageName) {
        val toBeMapped = Either.ofRight<String, NotificationStageName>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stageName = mapped
    }

    internal fun build(): NotificationPreferenceArgs = NotificationPreferenceArgs(
        sendNotification = sendNotification ?: throw PulumiNullFieldException("sendNotification"),
        stageName = stageName ?: throw PulumiNullFieldException("stageName"),
    )
}
