@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.inputs

import com.pulumi.azurenative.edgeorder.inputs.PreferencesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Preferences related to the order
 * @property encryptionPreferences Preferences related to the Encryption.
 * @property managementResourcePreferences Preferences related to the Management resource.
 * @property notificationPreferences Notification preferences.
 * @property transportPreferences Preferences related to the shipment logistics of the order.
 */
public data class PreferencesArgs(
    public val encryptionPreferences: Output<EncryptionPreferencesArgs>? = null,
    public val managementResourcePreferences: Output<ManagementResourcePreferencesArgs>? = null,
    public val notificationPreferences: Output<List<NotificationPreferenceArgs>>? = null,
    public val transportPreferences: Output<TransportPreferencesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.edgeorder.inputs.PreferencesArgs> {
    override fun toJava(): com.pulumi.azurenative.edgeorder.inputs.PreferencesArgs =
        com.pulumi.azurenative.edgeorder.inputs.PreferencesArgs.builder()
            .encryptionPreferences(
                encryptionPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .managementResourcePreferences(
                managementResourcePreferences?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .notificationPreferences(
                notificationPreferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .transportPreferences(
                transportPreferences?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [PreferencesArgs].
 */
@PulumiTagMarker
public class PreferencesArgsBuilder internal constructor() {
    private var encryptionPreferences: Output<EncryptionPreferencesArgs>? = null

    private var managementResourcePreferences: Output<ManagementResourcePreferencesArgs>? = null

    private var notificationPreferences: Output<List<NotificationPreferenceArgs>>? = null

    private var transportPreferences: Output<TransportPreferencesArgs>? = null

    /**
     * @param value Preferences related to the Encryption.
     */
    @JvmName("qavkwrlsyuxydmfq")
    public suspend fun encryptionPreferences(`value`: Output<EncryptionPreferencesArgs>) {
        this.encryptionPreferences = value
    }

    /**
     * @param value Preferences related to the Management resource.
     */
    @JvmName("vxjvkixmqkoiyjay")
    public suspend
    fun managementResourcePreferences(`value`: Output<ManagementResourcePreferencesArgs>) {
        this.managementResourcePreferences = value
    }

    /**
     * @param value Notification preferences.
     */
    @JvmName("kmfjvmkqwpbexqdp")
    public suspend fun notificationPreferences(`value`: Output<List<NotificationPreferenceArgs>>) {
        this.notificationPreferences = value
    }

    @JvmName("wgwrauggsbphkqbb")
    public suspend fun notificationPreferences(vararg values: Output<NotificationPreferenceArgs>) {
        this.notificationPreferences = Output.all(values.asList())
    }

    /**
     * @param values Notification preferences.
     */
    @JvmName("nruwnqvifrlstcwx")
    public suspend fun notificationPreferences(values: List<Output<NotificationPreferenceArgs>>) {
        this.notificationPreferences = Output.all(values)
    }

    /**
     * @param value Preferences related to the shipment logistics of the order.
     */
    @JvmName("sgpgkmyvyekjxgau")
    public suspend fun transportPreferences(`value`: Output<TransportPreferencesArgs>) {
        this.transportPreferences = value
    }

    /**
     * @param value Preferences related to the Encryption.
     */
    @JvmName("nxecoabvkystkyvj")
    public suspend fun encryptionPreferences(`value`: EncryptionPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionPreferences = mapped
    }

    /**
     * @param argument Preferences related to the Encryption.
     */
    @JvmName("guuqfbnowdyyymmo")
    public suspend
    fun encryptionPreferences(argument: suspend EncryptionPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = EncryptionPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionPreferences = mapped
    }

    /**
     * @param value Preferences related to the Management resource.
     */
    @JvmName("dxcaegcmkbxhlhkt")
    public suspend fun managementResourcePreferences(`value`: ManagementResourcePreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managementResourcePreferences = mapped
    }

    /**
     * @param argument Preferences related to the Management resource.
     */
    @JvmName("fqwslroadlophinv")
    public suspend
    fun managementResourcePreferences(argument: suspend ManagementResourcePreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = ManagementResourcePreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managementResourcePreferences = mapped
    }

    /**
     * @param value Notification preferences.
     */
    @JvmName("nebllyldbjdfhehv")
    public suspend fun notificationPreferences(`value`: List<NotificationPreferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notificationPreferences = mapped
    }

    /**
     * @param argument Notification preferences.
     */
    @JvmName("jxvedrtbtoqakdbe")
    public suspend
    fun notificationPreferences(argument: List<suspend NotificationPreferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NotificationPreferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationPreferences = mapped
    }

    /**
     * @param argument Notification preferences.
     */
    @JvmName("tgudlhopoqpostud")
    public suspend fun notificationPreferences(
        vararg
        argument: suspend NotificationPreferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NotificationPreferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.notificationPreferences = mapped
    }

    /**
     * @param argument Notification preferences.
     */
    @JvmName("jkatducjkyrisyaw")
    public suspend
    fun notificationPreferences(argument: suspend NotificationPreferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NotificationPreferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.notificationPreferences = mapped
    }

    /**
     * @param values Notification preferences.
     */
    @JvmName("tuartungpvmxnemd")
    public suspend fun notificationPreferences(vararg values: NotificationPreferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notificationPreferences = mapped
    }

    /**
     * @param value Preferences related to the shipment logistics of the order.
     */
    @JvmName("ghkefanxkhlivjsy")
    public suspend fun transportPreferences(`value`: TransportPreferencesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportPreferences = mapped
    }

    /**
     * @param argument Preferences related to the shipment logistics of the order.
     */
    @JvmName("lusbrbsprnejoewd")
    public suspend
    fun transportPreferences(argument: suspend TransportPreferencesArgsBuilder.() -> Unit) {
        val toBeMapped = TransportPreferencesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.transportPreferences = mapped
    }

    internal fun build(): PreferencesArgs = PreferencesArgs(
        encryptionPreferences = encryptionPreferences,
        managementResourcePreferences = managementResourcePreferences,
        notificationPreferences = notificationPreferences,
        transportPreferences = transportPreferences,
    )
}
