@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Availability information of a product system.
 * @property availabilityStage Current availability stage of the product.
 * @property disabledReason Reason why the product is disabled.
 * @property disabledReasonMessage Message for why the product is disabled.
 */
public data class AvailabilityInformationResponse(
    public val availabilityStage: String,
    public val disabledReason: String,
    public val disabledReasonMessage: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.AvailabilityInformationResponse):
            AvailabilityInformationResponse = AvailabilityInformationResponse(
            availabilityStage = javaType.availabilityStage(),
            disabledReason = javaType.disabledReason(),
            disabledReasonMessage = javaType.disabledReasonMessage(),
        )
    }
}
