@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Child configuration object.
 * @property availabilityInformation Availability information of the product system.
 * @property childConfigurationType Child configuration type.
 * @property childConfigurationTypes Different types of child configurations which exist for this configuration, these can be used to populate the child configuration filter.
 * @property costInformation Cost information for the product system.
 * @property description Description related to the product system.
 * @property dimensions Dimensions of the configuration.
 * @property displayName Display Name for the product system.
 * @property filterableProperties List of filters supported for a product.
 * @property fulfilledBy The entity responsible for fulfillment of the item at the given hierarchy level.
 * @property groupedChildConfigurations Child configurations present for the configuration after applying child configuration filter, grouped by the category name of the child configuration.
 * @property hierarchyInformation Hierarchy information of a product.
 * @property imageInformation Image information for the product system.
 * @property isPartOfBaseConfiguration Flag to indicate if the child configuration is part of the base configuration, which means the customer need not pass this configuration in OptInAdditionalConfigurations while placing an order, it will be shipped by default.
 * @property maximumQuantity Maximum quantity a customer can order while choosing this configuration.
 * @property minimumQuantity Minimum quantity a customer can order while choosing this configuration.
 * @property specifications Specifications of the configuration.
 */
public data class ChildConfigurationResponse(
    public val availabilityInformation: AvailabilityInformationResponse,
    public val childConfigurationType: String,
    public val childConfigurationTypes: List<String>,
    public val costInformation: CostInformationResponse,
    public val description: DescriptionResponse,
    public val dimensions: DimensionsResponse,
    public val displayName: String,
    public val filterableProperties: List<FilterablePropertyResponse>,
    public val fulfilledBy: String,
    public val groupedChildConfigurations: List<GroupedChildConfigurationsResponse>,
    public val hierarchyInformation: HierarchyInformationResponse,
    public val imageInformation: List<ImageInformationResponse>,
    public val isPartOfBaseConfiguration: Boolean,
    public val maximumQuantity: Int,
    public val minimumQuantity: Int,
    public val specifications: List<SpecificationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.ChildConfigurationResponse):
            ChildConfigurationResponse = ChildConfigurationResponse(
            availabilityInformation = javaType.availabilityInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.AvailabilityInformationResponse.Companion.toKotlin(args0)
            }),
            childConfigurationType = javaType.childConfigurationType(),
            childConfigurationTypes = javaType.childConfigurationTypes().map({ args0 -> args0 }),
            costInformation = javaType.costInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.CostInformationResponse.Companion.toKotlin(args0)
            }),
            description = javaType.description().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.DescriptionResponse.Companion.toKotlin(args0)
            }),
            dimensions = javaType.dimensions().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.DimensionsResponse.Companion.toKotlin(args0)
            }),
            displayName = javaType.displayName(),
            filterableProperties = javaType.filterableProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.FilterablePropertyResponse.Companion.toKotlin(args0)
                })
            }),
            fulfilledBy = javaType.fulfilledBy(),
            groupedChildConfigurations = javaType.groupedChildConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.GroupedChildConfigurationsResponse.Companion.toKotlin(args0)
                })
            }),
            hierarchyInformation = javaType.hierarchyInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.HierarchyInformationResponse.Companion.toKotlin(args0)
            }),
            imageInformation = javaType.imageInformation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ImageInformationResponse.Companion.toKotlin(args0)
                })
            }),
            isPartOfBaseConfiguration = javaType.isPartOfBaseConfiguration(),
            maximumQuantity = javaType.maximumQuantity(),
            minimumQuantity = javaType.minimumQuantity(),
            specifications = javaType.specifications().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.SpecificationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
