@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Grouped child configuration object.
 * @property categoryInformation Category information.
 * @property childConfigurations List of child configurations.
 */
public data class GroupedChildConfigurationsResponse(
    public val categoryInformation: CategoryInformationResponse,
    public val childConfigurations: List<ChildConfigurationResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.GroupedChildConfigurationsResponse):
            GroupedChildConfigurationsResponse = GroupedChildConfigurationsResponse(
            categoryInformation = javaType.categoryInformation().let({ args0 ->
                com.pulumi.azurenative.edgeorder.kotlin.outputs.CategoryInformationResponse.Companion.toKotlin(args0)
            }),
            childConfigurations = javaType.childConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.edgeorder.kotlin.outputs.ChildConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
