@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.edgeorder.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 * Billing type PAV2 meter details.
 * @property billingType Represents billing type.
 * Expected value is 'Pav2'.
 * @property chargingType Charging type.
 * @property meterGuid Validation status of requested data center and transport.
 * @property multiplier Billing unit applicable for Pav2 billing.
 */
public data class Pav2MeterDetailsResponse(
    public val billingType: String,
    public val chargingType: String,
    public val meterGuid: String,
    public val multiplier: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.edgeorder.outputs.Pav2MeterDetailsResponse):
            Pav2MeterDetailsResponse = Pav2MeterDetailsResponse(
            billingType = javaType.billingType(),
            chargingType = javaType.chargingType(),
            meterGuid = javaType.meterGuid(),
            multiplier = javaType.multiplier(),
        )
    }
}
