@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.education.kotlin.inputs

import com.pulumi.azurenative.education.inputs.GetLabPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property billingAccountName The ID that uniquely identifies a billing account.
 * @property billingProfileName The ID that uniquely identifies a billing profile.
 * @property includeBudget May be used to include budget information.
 * @property invoiceSectionName The ID that uniquely identifies an invoice section.
 */
public data class GetLabPlainArgs(
    public val billingAccountName: String,
    public val billingProfileName: String,
    public val includeBudget: Boolean? = null,
    public val invoiceSectionName: String,
) : ConvertibleToJava<com.pulumi.azurenative.education.inputs.GetLabPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.education.inputs.GetLabPlainArgs =
        com.pulumi.azurenative.education.inputs.GetLabPlainArgs.builder()
            .billingAccountName(billingAccountName.let({ args0 -> args0 }))
            .billingProfileName(billingProfileName.let({ args0 -> args0 }))
            .includeBudget(includeBudget?.let({ args0 -> args0 }))
            .invoiceSectionName(invoiceSectionName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLabPlainArgs].
 */
@PulumiTagMarker
public class GetLabPlainArgsBuilder internal constructor() {
    private var billingAccountName: String? = null

    private var billingProfileName: String? = null

    private var includeBudget: Boolean? = null

    private var invoiceSectionName: String? = null

    /**
     * @param value The ID that uniquely identifies a billing account.
     */
    @JvmName("cbcrqnfciehgqigp")
    public suspend fun billingAccountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingAccountName = mapped
    }

    /**
     * @param value The ID that uniquely identifies a billing profile.
     */
    @JvmName("qktclfrgxxlfwwwy")
    public suspend fun billingProfileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.billingProfileName = mapped
    }

    /**
     * @param value May be used to include budget information.
     */
    @JvmName("vkgsemtufsavfmpw")
    public suspend fun includeBudget(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeBudget = mapped
    }

    /**
     * @param value The ID that uniquely identifies an invoice section.
     */
    @JvmName("obljaymswpawdmge")
    public suspend fun invoiceSectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.invoiceSectionName = mapped
    }

    internal fun build(): GetLabPlainArgs = GetLabPlainArgs(
        billingAccountName = billingAccountName ?: throw PulumiNullFieldException("billingAccountName"),
        billingProfileName = billingProfileName ?: throw PulumiNullFieldException("billingProfileName"),
        includeBudget = includeBudget,
        invoiceSectionName = invoiceSectionName ?: throw PulumiNullFieldException("invoiceSectionName"),
    )
}
