@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elastic.kotlin.inputs

import com.pulumi.azurenative.elastic.inputs.IdentityPropertiesArgs.builder
import com.pulumi.azurenative.elastic.kotlin.enums.ManagedIdentityTypes
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity properties.
 * @property type Managed identity type.
 */
public data class IdentityPropertiesArgs(
    public val type: Output<Either<String, ManagedIdentityTypes>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elastic.inputs.IdentityPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.elastic.inputs.IdentityPropertiesArgs =
        com.pulumi.azurenative.elastic.inputs.IdentityPropertiesArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IdentityPropertiesArgs].
 */
@PulumiTagMarker
public class IdentityPropertiesArgsBuilder internal constructor() {
    private var type: Output<Either<String, ManagedIdentityTypes>>? = null

    /**
     * @param value Managed identity type.
     */
    @JvmName("hmfqrjjfayrvivtq")
    public suspend fun type(`value`: Output<Either<String, ManagedIdentityTypes>>) {
        this.type = value
    }

    /**
     * @param value Managed identity type.
     */
    @JvmName("snsacwlebkugshhi")
    public suspend fun type(`value`: Either<String, ManagedIdentityTypes>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed identity type.
     */
    @JvmName("mfwcidlmsmfvqyvu")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Managed identity type.
     */
    @JvmName("lgmfdgdpnnvymiri")
    public fun type(`value`: ManagedIdentityTypes) {
        val toBeMapped = Either.ofRight<String, ManagedIdentityTypes>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityPropertiesArgs = IdentityPropertiesArgs(
        type = type,
    )
}
