@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin

import com.pulumi.azurenative.elasticsan.VolumeGroupArgs.builder
import com.pulumi.azurenative.elasticsan.kotlin.enums.EncryptionType
import com.pulumi.azurenative.elasticsan.kotlin.enums.StorageTargetType
import com.pulumi.azurenative.elasticsan.kotlin.inputs.NetworkRuleSetArgs
import com.pulumi.azurenative.elasticsan.kotlin.inputs.NetworkRuleSetArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Response for Volume Group request.
 * Azure REST API version: 2021-11-20-preview. Prior API version in Azure Native 1.x: 2021-11-20-preview.
 * Other available API versions: 2022-12-01-preview, 2023-01-01.
 * ## Example Usage
 * ### VolumeGroups_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeGroup = new AzureNative.ElasticSan.VolumeGroup("volumeGroup", new()
 *     {
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         Encryption = "EncryptionAtRestWithPlatformKey",
 *         NetworkAcls = new AzureNative.ElasticSan.Inputs.NetworkRuleSetArgs
 *         {
 *             VirtualNetworkRules = new[]
 *             {
 *                 new AzureNative.ElasticSan.Inputs.VirtualNetworkRuleArgs
 *                 {
 *                     Action = AzureNative.ElasticSan.Action.Allow,
 *                     VirtualNetworkResourceId = "aaaaaaaaaaaaaaaa",
 *                 },
 *             },
 *         },
 *         ProtocolType = "Iscsi",
 *         ResourceGroupName = "rgelasticsan",
 *         Tags =
 *         {
 *             { "key5933", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa" },
 *         },
 *         VolumeGroupName = "u_5I_1j4t3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeGroup(ctx, "volumeGroup", &elasticsan.VolumeGroupArgs{
 * 			ElasticSanName: pulumi.String("ti7q-k952-1qB3J_5"),
 * 			Encryption:     pulumi.String("EncryptionAtRestWithPlatformKey"),
 * 			NetworkAcls: elasticsan.NetworkRuleSetResponse{
 * 				VirtualNetworkRules: elasticsan.VirtualNetworkRuleArray{
 * 					&elasticsan.VirtualNetworkRuleArgs{
 * 						Action:                   elasticsan.ActionAllow,
 * 						VirtualNetworkResourceId: pulumi.String("aaaaaaaaaaaaaaaa"),
 * 					},
 * 				},
 * 			},
 * 			ProtocolType:      pulumi.String("Iscsi"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			Tags: pulumi.StringMap{
 * 				"key5933": pulumi.String("aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"),
 * 			},
 * 			VolumeGroupName: pulumi.String("u_5I_1j4t3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeGroup;
 * import com.pulumi.azurenative.elasticsan.VolumeGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeGroup = new VolumeGroup("volumeGroup", VolumeGroupArgs.builder()
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .encryption("EncryptionAtRestWithPlatformKey")
 *             .networkAcls(Map.of("virtualNetworkRules", Map.ofEntries(
 *                 Map.entry("action", "Allow"),
 *                 Map.entry("virtualNetworkResourceId", "aaaaaaaaaaaaaaaa")
 *             )))
 *             .protocolType("Iscsi")
 *             .resourceGroupName("rgelasticsan")
 *             .tags(Map.of("key5933", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaa"))
 *             .volumeGroupName("u_5I_1j4t3")
 *             .build());
 *     }
 * }
 * ```
 * ### VolumeGroups_Create_MinimumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var volumeGroup = new AzureNative.ElasticSan.VolumeGroup("volumeGroup", new()
 *     {
 *         ElasticSanName = "ti7q-k952-1qB3J_5",
 *         ResourceGroupName = "rgelasticsan",
 *         VolumeGroupName = "u_5I_1j4t3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/elasticsan/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := elasticsan.NewVolumeGroup(ctx, "volumeGroup", &elasticsan.VolumeGroupArgs{
 * 			ElasticSanName:    pulumi.String("ti7q-k952-1qB3J_5"),
 * 			ResourceGroupName: pulumi.String("rgelasticsan"),
 * 			VolumeGroupName:   pulumi.String("u_5I_1j4t3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.elasticsan.VolumeGroup;
 * import com.pulumi.azurenative.elasticsan.VolumeGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var volumeGroup = new VolumeGroup("volumeGroup", VolumeGroupArgs.builder()
 *             .elasticSanName("ti7q-k952-1qB3J_5")
 *             .resourceGroupName("rgelasticsan")
 *             .volumeGroupName("u_5I_1j4t3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:elasticsan:VolumeGroup aaaaaaaaaaaaaaaaaaaaaa /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ElasticSan/elasticSans/{elasticSanName}/volumegroups/{volumeGroupName}
 * ```
 * @property elasticSanName The name of the ElasticSan.
 * @property encryption Type of encryption
 * @property networkAcls A collection of rules governing the accessibility from specific network locations.
 * @property protocolType Type of storage target
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Azure resource tags.
 * @property volumeGroupName The name of the VolumeGroup.
 */
public data class VolumeGroupArgs(
    public val elasticSanName: Output<String>? = null,
    public val encryption: Output<Either<String, EncryptionType>>? = null,
    public val networkAcls: Output<NetworkRuleSetArgs>? = null,
    public val protocolType: Output<Either<String, StorageTargetType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.VolumeGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.VolumeGroupArgs =
        com.pulumi.azurenative.elasticsan.VolumeGroupArgs.builder()
            .elasticSanName(elasticSanName?.applyValue({ args0 -> args0 }))
            .encryption(
                encryption?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .networkAcls(networkAcls?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protocolType(
                protocolType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeGroupName(volumeGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VolumeGroupArgs].
 */
@PulumiTagMarker
public class VolumeGroupArgsBuilder internal constructor() {
    private var elasticSanName: Output<String>? = null

    private var encryption: Output<Either<String, EncryptionType>>? = null

    private var networkAcls: Output<NetworkRuleSetArgs>? = null

    private var protocolType: Output<Either<String, StorageTargetType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeGroupName: Output<String>? = null

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("skkhuxawflhfetir")
    public suspend fun elasticSanName(`value`: Output<String>) {
        this.elasticSanName = value
    }

    /**
     * @param value Type of encryption
     */
    @JvmName("ohckkejuqjjrsuak")
    public suspend fun encryption(`value`: Output<Either<String, EncryptionType>>) {
        this.encryption = value
    }

    /**
     * @param value A collection of rules governing the accessibility from specific network locations.
     */
    @JvmName("aeokuahxdurbfrsq")
    public suspend fun networkAcls(`value`: Output<NetworkRuleSetArgs>) {
        this.networkAcls = value
    }

    /**
     * @param value Type of storage target
     */
    @JvmName("ylmfqopqunwjqtus")
    public suspend fun protocolType(`value`: Output<Either<String, StorageTargetType>>) {
        this.protocolType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("wmwwabtxhkmrttet")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("nxeguldmvjqqsiic")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("jhmkvjksmwthdajr")
    public suspend fun volumeGroupName(`value`: Output<String>) {
        this.volumeGroupName = value
    }

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("fctfyrojymcbweub")
    public suspend fun elasticSanName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.elasticSanName = mapped
    }

    /**
     * @param value Type of encryption
     */
    @JvmName("orcgpyqnukwtalnq")
    public suspend fun encryption(`value`: Either<String, EncryptionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param value Type of encryption
     */
    @JvmName("gjrjxddjfkbhgbjn")
    public fun encryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param value Type of encryption
     */
    @JvmName("pwpiviywuowipdhf")
    public fun encryption(`value`: EncryptionType) {
        val toBeMapped = Either.ofRight<String, EncryptionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryption = mapped
    }

    /**
     * @param value A collection of rules governing the accessibility from specific network locations.
     */
    @JvmName("nusjcfvtochiuywd")
    public suspend fun networkAcls(`value`: NetworkRuleSetArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkAcls = mapped
    }

    /**
     * @param argument A collection of rules governing the accessibility from specific network locations.
     */
    @JvmName("yyeeffwojfxjcogh")
    public suspend fun networkAcls(argument: suspend NetworkRuleSetArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRuleSetArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkAcls = mapped
    }

    /**
     * @param value Type of storage target
     */
    @JvmName("imgpshjmctiybqvo")
    public suspend fun protocolType(`value`: Either<String, StorageTargetType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Type of storage target
     */
    @JvmName("qicefrkgbmtyjerp")
    public fun protocolType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, StorageTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value Type of storage target
     */
    @JvmName("vfrasvkfwsaktmni")
    public fun protocolType(`value`: StorageTargetType) {
        val toBeMapped = Either.ofRight<String, StorageTargetType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cbvnlvwplpdokirv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("pqhdidrowpcwabyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("lllgviofgfxgygdw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("mcyferskjwlftpnw")
    public suspend fun volumeGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeGroupName = mapped
    }

    internal fun build(): VolumeGroupArgs = VolumeGroupArgs(
        elasticSanName = elasticSanName,
        encryption = encryption,
        networkAcls = networkAcls,
        protocolType = protocolType,
        resourceGroupName = resourceGroupName,
        tags = tags,
        volumeGroupName = volumeGroupName,
    )
}
