@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.GetElasticSanPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property elasticSanName The name of the ElasticSan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetElasticSanPlainArgs(
    public val elasticSanName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.GetElasticSanPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.GetElasticSanPlainArgs =
        com.pulumi.azurenative.elasticsan.inputs.GetElasticSanPlainArgs.builder()
            .elasticSanName(elasticSanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetElasticSanPlainArgs].
 */
@PulumiTagMarker
public class GetElasticSanPlainArgsBuilder internal constructor() {
    private var elasticSanName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("ivmnlujcneltdslw")
    public suspend fun elasticSanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.elasticSanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xsbxcemgybstgcvt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetElasticSanPlainArgs = GetElasticSanPlainArgs(
        elasticSanName = elasticSanName ?: throw PulumiNullFieldException("elasticSanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
