@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.inputs

import com.pulumi.azurenative.elasticsan.inputs.GetVolumePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property elasticSanName The name of the ElasticSan.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property volumeGroupName The name of the VolumeGroup.
 * @property volumeName The name of the Volume.
 */
public data class GetVolumePlainArgs(
    public val elasticSanName: String,
    public val resourceGroupName: String,
    public val volumeGroupName: String,
    public val volumeName: String,
) : ConvertibleToJava<com.pulumi.azurenative.elasticsan.inputs.GetVolumePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.elasticsan.inputs.GetVolumePlainArgs =
        com.pulumi.azurenative.elasticsan.inputs.GetVolumePlainArgs.builder()
            .elasticSanName(elasticSanName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .volumeGroupName(volumeGroupName.let({ args0 -> args0 }))
            .volumeName(volumeName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetVolumePlainArgs].
 */
@PulumiTagMarker
public class GetVolumePlainArgsBuilder internal constructor() {
    private var elasticSanName: String? = null

    private var resourceGroupName: String? = null

    private var volumeGroupName: String? = null

    private var volumeName: String? = null

    /**
     * @param value The name of the ElasticSan.
     */
    @JvmName("ahkbjcsgjbpgdiua")
    public suspend fun elasticSanName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.elasticSanName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qdmsqnacrytpcgld")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the VolumeGroup.
     */
    @JvmName("fqyrpptufcwruawo")
    public suspend fun volumeGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeGroupName = mapped
    }

    /**
     * @param value The name of the Volume.
     */
    @JvmName("yxocjwjpibbemvuv")
    public suspend fun volumeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.volumeName = mapped
    }

    internal fun build(): GetVolumePlainArgs = GetVolumePlainArgs(
        elasticSanName = elasticSanName ?: throw PulumiNullFieldException("elasticSanName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        volumeGroupName = volumeGroupName ?: throw PulumiNullFieldException("volumeGroupName"),
        volumeName = volumeName ?: throw PulumiNullFieldException("volumeName"),
    )
}
