@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.elasticsan.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Response for Volume Group request.
 * @property encryption Type of encryption
 * @property id Azure resource identifier.
 * @property name Azure resource name.
 * @property networkAcls A collection of rules governing the accessibility from specific network locations.
 * @property protocolType Type of storage target
 * @property provisioningState State of the operation on the resource.
 * @property systemData Resource metadata required by ARM RPC
 * @property tags Azure resource tags.
 * @property type Azure resource type.
 */
public data class GetVolumeGroupResult(
    public val encryption: String? = null,
    public val id: String,
    public val name: String,
    public val networkAcls: NetworkRuleSetResponse? = null,
    public val protocolType: String? = null,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.elasticsan.outputs.GetVolumeGroupResult):
            GetVolumeGroupResult = GetVolumeGroupResult(
            encryption = javaType.encryption().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            networkAcls = javaType.networkAcls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.elasticsan.kotlin.outputs.NetworkRuleSetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protocolType = javaType.protocolType().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.elasticsan.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
