@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.engagementfabric.kotlin.inputs

import com.pulumi.azurenative.engagementfabric.inputs.ListAccountChannelTypesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accountName Account Name
 * @property resourceGroupName Resource Group Name
 */
public data class ListAccountChannelTypesPlainArgs(
    public val accountName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.engagementfabric.inputs.ListAccountChannelTypesPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.engagementfabric.inputs.ListAccountChannelTypesPlainArgs =
        com.pulumi.azurenative.engagementfabric.inputs.ListAccountChannelTypesPlainArgs.builder()
            .accountName(accountName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListAccountChannelTypesPlainArgs].
 */
@PulumiTagMarker
public class ListAccountChannelTypesPlainArgsBuilder internal constructor() {
    private var accountName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Account Name
     */
    @JvmName("jmmcexndulydbgfi")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accountName = mapped
    }

    /**
     * @param value Resource Group Name
     */
    @JvmName("igafdimvyuhcnmna")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListAccountChannelTypesPlainArgs = ListAccountChannelTypesPlainArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
