@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.inputs

import com.pulumi.azurenative.enterpriseknowledgegraph.inputs.GetEnterpriseKnowledgeGraphPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the EnterpriseKnowledgeGraph resource group in the user subscription.
 * @property resourceName The name of the EnterpriseKnowledgeGraph resource.
 */
public data class GetEnterpriseKnowledgeGraphPlainArgs(
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.enterpriseknowledgegraph.inputs.GetEnterpriseKnowledgeGraphPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.enterpriseknowledgegraph.inputs.GetEnterpriseKnowledgeGraphPlainArgs =
        com.pulumi.azurenative.enterpriseknowledgegraph.inputs.GetEnterpriseKnowledgeGraphPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnterpriseKnowledgeGraphPlainArgs].
 */
@PulumiTagMarker
public class GetEnterpriseKnowledgeGraphPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the EnterpriseKnowledgeGraph resource group in the user subscription.
     */
    @JvmName("sopsrofuaewlgjxn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the EnterpriseKnowledgeGraph resource.
     */
    @JvmName("cunvjcaatkatxvuy")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetEnterpriseKnowledgeGraphPlainArgs = GetEnterpriseKnowledgeGraphPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
