@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * EnterpriseKnowledgeGraph resource definition
 * @property id Specifies the resource ID.
 * @property location Specifies the location of the resource.
 * @property name Specifies the name of the resource.
 * @property properties The set of properties specific to EnterpriseKnowledgeGraph resource
 * @property sku Gets or sets the SKU of the resource.
 * @property tags Contains resource tags defined as key/value pairs.
 * @property type Specifies the type of the resource.
 */
public data class GetEnterpriseKnowledgeGraphResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: EnterpriseKnowledgeGraphPropertiesResponse,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.enterpriseknowledgegraph.outputs.GetEnterpriseKnowledgeGraphResult):
            GetEnterpriseKnowledgeGraphResult = GetEnterpriseKnowledgeGraphResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.EnterpriseKnowledgeGraphPropertiesResponse.Companion.toKotlin(args0)
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.enterpriseknowledgegraph.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
