@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.CaCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The CA Certificate resource.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### CaCertificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var caCertificate = new AzureNative.EventGrid.CaCertificate("caCertificate", new()
 *     {
 *         CaCertificateName = "exampleCACertificateName1",
 *         Description = "This is a test certificate",
 *         EncodedCertificate = "base64EncodePemFormattedCertificateString",
 *         NamespaceName = "exampleNamespaceName1",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewCaCertificate(ctx, "caCertificate", &eventgrid.CaCertificateArgs{
 * 			CaCertificateName:  pulumi.String("exampleCACertificateName1"),
 * 			Description:        pulumi.String("This is a test certificate"),
 * 			EncodedCertificate: pulumi.String("base64EncodePemFormattedCertificateString"),
 * 			NamespaceName:      pulumi.String("exampleNamespaceName1"),
 * 			ResourceGroupName:  pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.CaCertificate;
 * import com.pulumi.azurenative.eventgrid.CaCertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var caCertificate = new CaCertificate("caCertificate", CaCertificateArgs.builder()
 *             .caCertificateName("exampleCACertificateName1")
 *             .description("This is a test certificate")
 *             .encodedCertificate("base64EncodePemFormattedCertificateString")
 *             .namespaceName("exampleNamespaceName1")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:CaCertificate exampleCACertificateName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/caCertificates/{caCertificateName}
 * ```
 * @property caCertificateName The CA certificate name.
 * @property description Description for the CA Certificate resource.
 * @property encodedCertificate Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
 * @property namespaceName Name of the namespace.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class CaCertificateArgs(
    public val caCertificateName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val encodedCertificate: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.CaCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.CaCertificateArgs =
        com.pulumi.azurenative.eventgrid.CaCertificateArgs.builder()
            .caCertificateName(caCertificateName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encodedCertificate(encodedCertificate?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CaCertificateArgs].
 */
@PulumiTagMarker
public class CaCertificateArgsBuilder internal constructor() {
    private var caCertificateName: Output<String>? = null

    private var description: Output<String>? = null

    private var encodedCertificate: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The CA certificate name.
     */
    @JvmName("vrciqpbonbuducxu")
    public suspend fun caCertificateName(`value`: Output<String>) {
        this.caCertificateName = value
    }

    /**
     * @param value Description for the CA Certificate resource.
     */
    @JvmName("pjwqmdhsbsfwqams")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     */
    @JvmName("piuxpektqdemumid")
    public suspend fun encodedCertificate(`value`: Output<String>) {
        this.encodedCertificate = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("xgvfwmhxtqtvcvpc")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("yffsdhxwejblrahc")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The CA certificate name.
     */
    @JvmName("xavsqqsdtdwgtjts")
    public suspend fun caCertificateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.caCertificateName = mapped
    }

    /**
     * @param value Description for the CA Certificate resource.
     */
    @JvmName("ffviukcsjweqqdrp")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Base64 encoded PEM (Privacy Enhanced Mail) format certificate data.
     */
    @JvmName("ktbendwkmjpiauem")
    public suspend fun encodedCertificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encodedCertificate = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("hfpftluphtinqtcm")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("cvmdabmieairtuwi")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CaCertificateArgs = CaCertificateArgs(
        caCertificateName = caCertificateName,
        description = description,
        encodedCertificate = encodedCertificate,
        namespaceName = namespaceName,
        resourceGroupName = resourceGroupName,
    )
}
