@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.EventDeliverySchema
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeadLetterWithResourceIdentityArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeadLetterWithResourceIdentityArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryWithResourceIdentityArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.DeliveryWithResourceIdentityArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventSubscriptionFilterArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventSubscriptionFilterArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.RetryPolicyArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.RetryPolicyArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.StorageBlobDeadLetterDestinationArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.StorageBlobDeadLetterDestinationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Event Subscription
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2017-06-15-preview, 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.EventHubEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "EventHub",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.EventHubEventSubscriptionDestination{
 * 				EndpointType: "EventHub",
 * 				ResourceId:   "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "EventHub"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_AzureFunctionDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.AzureFunctionEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "AzureFunction",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Web/sites/ContosoSite/funtions/ContosoFunc",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.AzureFunctionEventSubscriptionDestination{
 * EndpointType: "AzureFunction",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Web/sites/ContosoSite/funtions/ContosoFunc",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "AzureFunction"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Web/sites/ContosoSite/funtions/ContosoFunc")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_EventHubDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.EventHubEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "EventHub",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.EventHubEventSubscriptionDestination{
 * EndpointType: "EventHub",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "EventHub"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.EventHub/namespaces/ContosoNamespace/eventhubs/EH1")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_HybridConnectionDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.HybridConnectionEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "HybridConnection",
 *             ResourceId = "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Relay/namespaces/ContosoNamespace/hybridConnections/HC1",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.HybridConnectionEventSubscriptionDestination{
 * EndpointType: "HybridConnection",
 * ResourceId: "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Relay/namespaces/ContosoNamespace/hybridConnections/HC1",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "HybridConnection"),
 *                 Map.entry("resourceId", "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Relay/namespaces/ContosoNamespace/hybridConnections/HC1")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_ServiceBusQueueDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.ServiceBusQueueEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "ServiceBusQueue",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/queues/SBQ",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.ServiceBusQueueEventSubscriptionDestination{
 * EndpointType: "ServiceBusQueue",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/queues/SBQ",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "ServiceBusQueue"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/queues/SBQ")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_ServiceBusTopicDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.ServiceBusTopicEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "ServiceBusTopic",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/topics/SBT",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.ServiceBusTopicEventSubscriptionDestination{
 * EndpointType: "ServiceBusTopic",
 * ResourceId: "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/topics/SBT",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "ServiceBusTopic"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.ServiceBus/namespaces/ContosoNamespace/topics/SBT")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_StorageQueueDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         DeadLetterDestination = new AzureNative.EventGrid.Inputs.StorageBlobDeadLetterDestinationArgs
 *         {
 *             BlobContainerName = "contosocontainer",
 *             EndpointType = "StorageBlob",
 *             ResourceId = "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         Destination = new AzureNative.EventGrid.Inputs.StorageQueueEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "StorageQueue",
 *             QueueName = "queue1",
 *             ResourceId = "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * DeadLetterDestination: interface{}{
 * BlobContainerName: pulumi.String("contosocontainer"),
 * EndpointType: pulumi.String("StorageBlob"),
 * ResourceId: pulumi.String("/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg"),
 * },
 * Destination: eventgrid.StorageQueueEventSubscriptionDestination{
 * EndpointType: "StorageQueue",
 * QueueName: "queue1",
 * ResourceId: "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg",
 * },
 * EventSubscriptionName: pulumi.String("examplesubscription1"),
 * Filter: &eventgrid.EventSubscriptionFilterArgs{
 * IsSubjectCaseSensitive: pulumi.Bool(false),
 * SubjectBeginsWith: pulumi.String("ExamplePrefix"),
 * SubjectEndsWith: pulumi.String("ExampleSuffix"),
 * },
 * Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .deadLetterDestination(Map.ofEntries(
 *                 Map.entry("blobContainerName", "contosocontainer"),
 *                 Map.entry("endpointType", "StorageBlob"),
 *                 Map.entry("resourceId", "/subscriptions/55f3dcd4-cac7-43b4-990b-a139d62a1eb2/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "StorageQueue"),
 *                 Map.entry("queueName", "queue1"),
 *                 Map.entry("resourceId", "/subscriptions/d33c5f7a-02ea-40f4-bf52-07f17e84d6a8/resourceGroups/TestRG/providers/Microsoft.Storage/storageAccounts/contosostg")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForCustomTopic_WebhookDestination
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://azurefunctionexample.azurewebsites.net/runtime/webhooks/EventGrid?functionName=EventGridTrigger1&code=PASSWORDCODE",
 *         },
 *         EventSubscriptionName = "examplesubscription1",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://azurefunctionexample.azurewebsites.net/runtime/webhooks/EventGrid?functionName=EventGridTrigger1&code=PASSWORDCODE",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription1"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://azurefunctionexample.azurewebsites.net/runtime/webhooks/EventGrid?functionName=EventGridTrigger1&code=PASSWORDCODE")
 *             ))
 *             .eventSubscriptionName("examplesubscription1")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventGrid/topics/exampletopic1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForResource
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "examplesubscription10",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventHub/namespaces/examplenamespace1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription10"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventHub/namespaces/examplenamespace1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("examplesubscription10")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg/providers/Microsoft.EventHub/namespaces/examplenamespace1")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForResourceGroup
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "examplesubscription2",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *             SubjectBeginsWith = "ExamplePrefix",
 *             SubjectEndsWith = "ExampleSuffix",
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription2"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 				SubjectBeginsWith:      pulumi.String("ExamplePrefix"),
 * 				SubjectEndsWith:        pulumi.String("ExampleSuffix"),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("examplesubscription2")
 *             .filter(Map.ofEntries(
 *                 Map.entry("isSubjectCaseSensitive", false),
 *                 Map.entry("subjectBeginsWith", "ExamplePrefix"),
 *                 Map.entry("subjectEndsWith", "ExampleSuffix")
 *             ))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4/resourceGroups/examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ### EventSubscriptions_CreateOrUpdateForSubscription
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var eventSubscription = new AzureNative.EventGrid.EventSubscription("eventSubscription", new()
 *     {
 *         Destination = new AzureNative.EventGrid.Inputs.WebHookEventSubscriptionDestinationArgs
 *         {
 *             EndpointType = "WebHook",
 *             EndpointUrl = "https://requestb.in/15ksip71",
 *         },
 *         EventSubscriptionName = "examplesubscription3",
 *         Filter = new AzureNative.EventGrid.Inputs.EventSubscriptionFilterArgs
 *         {
 *             IsSubjectCaseSensitive = false,
 *         },
 *         Scope = "subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewEventSubscription(ctx, "eventSubscription", &eventgrid.EventSubscriptionArgs{
 * 			Destination: eventgrid.WebHookEventSubscriptionDestination{
 * 				EndpointType: "WebHook",
 * 				EndpointUrl:  "https://requestb.in/15ksip71",
 * 			},
 * 			EventSubscriptionName: pulumi.String("examplesubscription3"),
 * 			Filter: &eventgrid.EventSubscriptionFilterArgs{
 * 				IsSubjectCaseSensitive: pulumi.Bool(false),
 * 			},
 * 			Scope: pulumi.String("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.EventSubscription;
 * import com.pulumi.azurenative.eventgrid.EventSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var eventSubscription = new EventSubscription("eventSubscription", EventSubscriptionArgs.builder()
 *             .destination(Map.ofEntries(
 *                 Map.entry("endpointType", "WebHook"),
 *                 Map.entry("endpointUrl", "https://requestb.in/15ksip71")
 *             ))
 *             .eventSubscriptionName("examplesubscription3")
 *             .filter(Map.of("isSubjectCaseSensitive", false))
 *             .scope("subscriptions/5b4b650e-28b9-4790-b3ab-ddbd88d727c4")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:EventSubscription examplesubscription3 /{scope}/providers/Microsoft.EventGrid/eventSubscriptions/{eventSubscriptionName}
 * ```
 * @property deadLetterDestination The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deadLetterWithResourceIdentity The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property deliveryWithResourceIdentity Information about the destination where events have to be delivered for the event subscription.
 * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property destination Information about the destination where events have to be delivered for the event subscription.
 * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
 * @property eventDeliverySchema The event delivery schema for the event subscription.
 * @property eventSubscriptionName Name of the event subscription. Event subscription names must be between 3 and 64 characters in length and should use alphanumeric letters only.
 * @property expirationTimeUtc Expiration time of the event subscription.
 * @property filter Information about the filter for the event subscription.
 * @property labels List of user defined labels.
 * @property retryPolicy The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
 * @property scope The identifier of the resource to which the event subscription needs to be created or updated. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
 */
public data class EventSubscriptionArgs(
    public val deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null,
    public val deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? = null,
    public val deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityArgs>? = null,
    public val destination: Output<Any>? = null,
    public val eventDeliverySchema: Output<Either<String, EventDeliverySchema>>? = null,
    public val eventSubscriptionName: Output<String>? = null,
    public val expirationTimeUtc: Output<String>? = null,
    public val filter: Output<EventSubscriptionFilterArgs>? = null,
    public val labels: Output<List<String>>? = null,
    public val retryPolicy: Output<RetryPolicyArgs>? = null,
    public val scope: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.EventSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.EventSubscriptionArgs =
        com.pulumi.azurenative.eventgrid.EventSubscriptionArgs.builder()
            .deadLetterDestination(
                deadLetterDestination?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .deadLetterWithResourceIdentity(
                deadLetterWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .deliveryWithResourceIdentity(
                deliveryWithResourceIdentity?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .destination(destination?.applyValue({ args0 -> args0 }))
            .eventDeliverySchema(
                eventDeliverySchema?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .eventSubscriptionName(eventSubscriptionName?.applyValue({ args0 -> args0 }))
            .expirationTimeUtc(expirationTimeUtc?.applyValue({ args0 -> args0 }))
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .retryPolicy(retryPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scope(scope?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EventSubscriptionArgs].
 */
@PulumiTagMarker
public class EventSubscriptionArgsBuilder internal constructor() {
    private var deadLetterDestination: Output<StorageBlobDeadLetterDestinationArgs>? = null

    private var deadLetterWithResourceIdentity: Output<DeadLetterWithResourceIdentityArgs>? = null

    private var deliveryWithResourceIdentity: Output<DeliveryWithResourceIdentityArgs>? = null

    private var destination: Output<Any>? = null

    private var eventDeliverySchema: Output<Either<String, EventDeliverySchema>>? = null

    private var eventSubscriptionName: Output<String>? = null

    private var expirationTimeUtc: Output<String>? = null

    private var filter: Output<EventSubscriptionFilterArgs>? = null

    private var labels: Output<List<String>>? = null

    private var retryPolicy: Output<RetryPolicyArgs>? = null

    private var scope: Output<String>? = null

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("qfkryofpdokepqlq")
    public suspend fun deadLetterDestination(`value`: Output<StorageBlobDeadLetterDestinationArgs>) {
        this.deadLetterDestination = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("qrrawdrfbmvbimdc")
    public suspend
    fun deadLetterWithResourceIdentity(`value`: Output<DeadLetterWithResourceIdentityArgs>) {
        this.deadLetterWithResourceIdentity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("rvpmnaorqyhsdgco")
    public suspend
    fun deliveryWithResourceIdentity(`value`: Output<DeliveryWithResourceIdentityArgs>) {
        this.deliveryWithResourceIdentity = value
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("rpldpufdgettxmce")
    public suspend fun destination(`value`: Output<Any>) {
        this.destination = value
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("dflqmohcaelpcgou")
    public suspend fun eventDeliverySchema(`value`: Output<Either<String, EventDeliverySchema>>) {
        this.eventDeliverySchema = value
    }

    /**
     * @param value Name of the event subscription. Event subscription names must be between 3 and 64 characters in length and should use alphanumeric letters only.
     */
    @JvmName("nxwexjfehvxonaod")
    public suspend fun eventSubscriptionName(`value`: Output<String>) {
        this.eventSubscriptionName = value
    }

    /**
     * @param value Expiration time of the event subscription.
     */
    @JvmName("yrgokekqhoevrgyj")
    public suspend fun expirationTimeUtc(`value`: Output<String>) {
        this.expirationTimeUtc = value
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("hfqvnweyrmfrjrqi")
    public suspend fun filter(`value`: Output<EventSubscriptionFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value List of user defined labels.
     */
    @JvmName("plreispruaiemiut")
    public suspend fun labels(`value`: Output<List<String>>) {
        this.labels = value
    }

    @JvmName("tcectsxtwhyinxac")
    public suspend fun labels(vararg values: Output<String>) {
        this.labels = Output.all(values.asList())
    }

    /**
     * @param values List of user defined labels.
     */
    @JvmName("jgbiwamyodvgwioo")
    public suspend fun labels(values: List<Output<String>>) {
        this.labels = Output.all(values)
    }

    /**
     * @param value The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("juvjjkollvqaboba")
    public suspend fun retryPolicy(`value`: Output<RetryPolicyArgs>) {
        this.retryPolicy = value
    }

    /**
     * @param value The identifier of the resource to which the event subscription needs to be created or updated. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
     */
    @JvmName("mmtohnielvaynuwh")
    public suspend fun scope(`value`: Output<String>) {
        this.scope = value
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("sddwbnercbiymhyx")
    public suspend fun deadLetterDestination(`value`: StorageBlobDeadLetterDestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterDestination = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("kdlumrffgjqrtqti")
    public suspend
    fun deadLetterDestination(argument: suspend StorageBlobDeadLetterDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = StorageBlobDeadLetterDestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.deadLetterDestination = mapped
    }

    /**
     * @param value The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("oclrerjissijyiyj")
    public suspend fun deadLetterWithResourceIdentity(`value`: DeadLetterWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetterWithResourceIdentity = mapped
    }

    /**
     * @param argument The dead letter destination of the event subscription. Any event that cannot be delivered to its' destination is sent to the dead letter destination.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("lhgtiiprpmnknncc")
    public suspend
    fun deadLetterWithResourceIdentity(argument: suspend DeadLetterWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeadLetterWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deadLetterWithResourceIdentity = mapped
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("xitewnhftnixnqeh")
    public suspend fun deliveryWithResourceIdentity(`value`: DeliveryWithResourceIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deliveryWithResourceIdentity = mapped
    }

    /**
     * @param argument Information about the destination where events have to be delivered for the event subscription.
     * Uses the managed identity setup on the parent resource (namely, topic or domain) to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("wluubyhjndukcrba")
    public suspend
    fun deliveryWithResourceIdentity(argument: suspend DeliveryWithResourceIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = DeliveryWithResourceIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.deliveryWithResourceIdentity = mapped
    }

    /**
     * @param value Information about the destination where events have to be delivered for the event subscription.
     * Uses Azure Event Grid's identity to acquire the authentication tokens being used during delivery / dead-lettering.
     */
    @JvmName("wdybvqlefjanqrum")
    public suspend fun destination(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("roxouqjmrugvxtpi")
    public suspend fun eventDeliverySchema(`value`: Either<String, EventDeliverySchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("imqufogowkfardgb")
    public fun eventDeliverySchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventDeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value The event delivery schema for the event subscription.
     */
    @JvmName("ynwkpsyobgigiyif")
    public fun eventDeliverySchema(`value`: EventDeliverySchema) {
        val toBeMapped = Either.ofRight<String, EventDeliverySchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eventDeliverySchema = mapped
    }

    /**
     * @param value Name of the event subscription. Event subscription names must be between 3 and 64 characters in length and should use alphanumeric letters only.
     */
    @JvmName("niswxhhfylaqvskp")
    public suspend fun eventSubscriptionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventSubscriptionName = mapped
    }

    /**
     * @param value Expiration time of the event subscription.
     */
    @JvmName("ypjsvgirxrnsyovl")
    public suspend fun expirationTimeUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeUtc = mapped
    }

    /**
     * @param value Information about the filter for the event subscription.
     */
    @JvmName("bdrrlaqprsyjwwkq")
    public suspend fun filter(`value`: EventSubscriptionFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument Information about the filter for the event subscription.
     */
    @JvmName("sihwsuwgmipycuva")
    public suspend fun filter(argument: suspend EventSubscriptionFilterArgsBuilder.() -> Unit) {
        val toBeMapped = EventSubscriptionFilterArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value List of user defined labels.
     */
    @JvmName("elemciecaytedkex")
    public suspend fun labels(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values List of user defined labels.
     */
    @JvmName("hwbderivhaspknnx")
    public suspend fun labels(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("dkhgyxtdjnvegwag")
    public suspend fun retryPolicy(`value`: RetryPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryPolicy = mapped
    }

    /**
     * @param argument The retry policy for events. This can be used to configure maximum number of delivery attempts and time to live for events.
     */
    @JvmName("grhjdyftpgbydtes")
    public suspend fun retryPolicy(argument: suspend RetryPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = RetryPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.retryPolicy = mapped
    }

    /**
     * @param value The identifier of the resource to which the event subscription needs to be created or updated. The scope can be a subscription, or a resource group, or a top level resource belonging to a resource provider namespace, or an EventGrid topic. For example, use '/subscriptions/{subscriptionId}/' for a subscription, '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}' for a resource group, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}' for a resource, and '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/topics/{topicName}' for an EventGrid topic.
     */
    @JvmName("icgibaoinxqmyefj")
    public suspend fun scope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scope = mapped
    }

    internal fun build(): EventSubscriptionArgs = EventSubscriptionArgs(
        deadLetterDestination = deadLetterDestination,
        deadLetterWithResourceIdentity = deadLetterWithResourceIdentity,
        deliveryWithResourceIdentity = deliveryWithResourceIdentity,
        destination = destination,
        eventDeliverySchema = eventDeliverySchema,
        eventSubscriptionName = eventSubscriptionName,
        expirationTimeUtc = expirationTimeUtc,
        filter = filter,
        labels = labels,
        retryPolicy = retryPolicy,
        scope = scope,
    )
}
