@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.NamespaceTopicArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.EventInputSchema
import com.pulumi.azurenative.eventgrid.kotlin.enums.PublisherType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Namespace topic details.
 * Azure REST API version: 2023-06-01-preview.
 * Other available API versions: 2023-12-15-preview.
 * ## Example Usage
 * ### NamespaceTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceTopic = new AzureNative.EventGrid.NamespaceTopic("namespaceTopic", new()
 *     {
 *         EventRetentionInDays = 1,
 *         InputSchema = "CloudEventSchemaV1_0",
 *         NamespaceName = "examplenamespace2",
 *         PublisherType = "Custom",
 *         ResourceGroupName = "examplerg",
 *         TopicName = "examplenamespacetopic2",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewNamespaceTopic(ctx, "namespaceTopic", &eventgrid.NamespaceTopicArgs{
 * 			EventRetentionInDays: pulumi.Int(1),
 * 			InputSchema:          pulumi.String("CloudEventSchemaV1_0"),
 * 			NamespaceName:        pulumi.String("examplenamespace2"),
 * 			PublisherType:        pulumi.String("Custom"),
 * 			ResourceGroupName:    pulumi.String("examplerg"),
 * 			TopicName:            pulumi.String("examplenamespacetopic2"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopic;
 * import com.pulumi.azurenative.eventgrid.NamespaceTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceTopic = new NamespaceTopic("namespaceTopic", NamespaceTopicArgs.builder()
 *             .eventRetentionInDays(1)
 *             .inputSchema("CloudEventSchemaV1_0")
 *             .namespaceName("examplenamespace2")
 *             .publisherType("Custom")
 *             .resourceGroupName("examplerg")
 *             .topicName("examplenamespacetopic2")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:NamespaceTopic examplenamespacetopic2 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/namespaces/{namespaceName}/topics/{topicName}
 * ```
 * @property eventRetentionInDays Event retention for the namespace topic expressed in days. The property default value is 1 day.
 * Min event retention duration value is 1 day and max event retention duration value is 1 day.
 * @property inputSchema This determines the format that is expected for incoming events published to the topic.
 * @property namespaceName Name of the namespace.
 * @property publisherType Publisher type of the namespace topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property topicName Name of the namespace topic.
 */
public data class NamespaceTopicArgs(
    public val eventRetentionInDays: Output<Int>? = null,
    public val inputSchema: Output<Either<String, EventInputSchema>>? = null,
    public val namespaceName: Output<String>? = null,
    public val publisherType: Output<Either<String, PublisherType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val topicName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.NamespaceTopicArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.NamespaceTopicArgs =
        com.pulumi.azurenative.eventgrid.NamespaceTopicArgs.builder()
            .eventRetentionInDays(eventRetentionInDays?.applyValue({ args0 -> args0 }))
            .inputSchema(
                inputSchema?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .publisherType(
                publisherType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .topicName(topicName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamespaceTopicArgs].
 */
@PulumiTagMarker
public class NamespaceTopicArgsBuilder internal constructor() {
    private var eventRetentionInDays: Output<Int>? = null

    private var inputSchema: Output<Either<String, EventInputSchema>>? = null

    private var namespaceName: Output<String>? = null

    private var publisherType: Output<Either<String, PublisherType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var topicName: Output<String>? = null

    /**
     * @param value Event retention for the namespace topic expressed in days. The property default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     */
    @JvmName("umfxxpmjeoaftpoa")
    public suspend fun eventRetentionInDays(`value`: Output<Int>) {
        this.eventRetentionInDays = value
    }

    /**
     * @param value This determines the format that is expected for incoming events published to the topic.
     */
    @JvmName("vhkhpwbnmaruutwf")
    public suspend fun inputSchema(`value`: Output<Either<String, EventInputSchema>>) {
        this.inputSchema = value
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("rposlinrivrhwxei")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value Publisher type of the namespace topic.
     */
    @JvmName("wfbkrckfixgisxnj")
    public suspend fun publisherType(`value`: Output<Either<String, PublisherType>>) {
        this.publisherType = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("jiorynqhqrrhfxsk")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("gdrtjturjcdklofu")
    public suspend fun topicName(`value`: Output<String>) {
        this.topicName = value
    }

    /**
     * @param value Event retention for the namespace topic expressed in days. The property default value is 1 day.
     * Min event retention duration value is 1 day and max event retention duration value is 1 day.
     */
    @JvmName("wedxjyreydbfgyol")
    public suspend fun eventRetentionInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventRetentionInDays = mapped
    }

    /**
     * @param value This determines the format that is expected for incoming events published to the topic.
     */
    @JvmName("ixgufdcfwpjreutv")
    public suspend fun inputSchema(`value`: Either<String, EventInputSchema>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This determines the format that is expected for incoming events published to the topic.
     */
    @JvmName("cvoqgstjvayouger")
    public fun inputSchema(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EventInputSchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value This determines the format that is expected for incoming events published to the topic.
     */
    @JvmName("jtllhxuhtbessepl")
    public fun inputSchema(`value`: EventInputSchema) {
        val toBeMapped = Either.ofRight<String, EventInputSchema>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSchema = mapped
    }

    /**
     * @param value Name of the namespace.
     */
    @JvmName("tqwsmhbrhgcujqbq")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value Publisher type of the namespace topic.
     */
    @JvmName("wvxnihivyrurunwq")
    public suspend fun publisherType(`value`: Either<String, PublisherType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publisherType = mapped
    }

    /**
     * @param value Publisher type of the namespace topic.
     */
    @JvmName("ioeukurhdlybnmmv")
    public fun publisherType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublisherType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisherType = mapped
    }

    /**
     * @param value Publisher type of the namespace topic.
     */
    @JvmName("avcloyuuxsfsnygk")
    public fun publisherType(`value`: PublisherType) {
        val toBeMapped = Either.ofRight<String, PublisherType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisherType = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("ytnwcsnahvqloivk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the namespace topic.
     */
    @JvmName("ncsglstdllljkofy")
    public suspend fun topicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.topicName = mapped
    }

    internal fun build(): NamespaceTopicArgs = NamespaceTopicArgs(
        eventRetentionInDays = eventRetentionInDays,
        inputSchema = inputSchema,
        namespaceName = namespaceName,
        publisherType = publisherType,
        resourceGroupName = resourceGroupName,
        topicName = topicName,
    )
}
