@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PartnerDestination].
 */
@PulumiTagMarker
public class PartnerDestinationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerDestinationArgs = PartnerDestinationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerDestinationArgsBuilder.() -> Unit) {
        val builder = PartnerDestinationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PartnerDestination {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.PartnerDestination(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PartnerDestination(builtJavaResource)
    }
}

/**
 * Event Grid Partner Destination.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2021-10-15-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerDestinations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerDestination = new AzureNative.EventGrid.PartnerDestination("partnerDestination", new()
 *     {
 *         EndpointBaseUrl = "https://www.example/endpoint",
 *         EndpointServiceContext = "This is an example",
 *         ExpirationTimeIfNotActivatedUtc = "2022-03-14T19:33:43.430Z",
 *         Location = "westus2",
 *         MessageForActivation = "Sample Activation message",
 *         PartnerDestinationName = "examplePartnerDestinationName1",
 *         PartnerRegistrationImmutableId = "0bd70ee2-7d95-447e-ab1f-c4f320019404",
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerDestination(ctx, "partnerDestination", &eventgrid.PartnerDestinationArgs{
 * 			EndpointBaseUrl:                 pulumi.String("https://www.example/endpoint"),
 * 			EndpointServiceContext:          pulumi.String("This is an example"),
 * 			ExpirationTimeIfNotActivatedUtc: pulumi.String("2022-03-14T19:33:43.430Z"),
 * 			Location:                        pulumi.String("westus2"),
 * 			MessageForActivation:            pulumi.String("Sample Activation message"),
 * 			PartnerDestinationName:          pulumi.String("examplePartnerDestinationName1"),
 * 			PartnerRegistrationImmutableId:  pulumi.String("0bd70ee2-7d95-447e-ab1f-c4f320019404"),
 * 			ResourceGroupName:               pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerDestination;
 * import com.pulumi.azurenative.eventgrid.PartnerDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerDestination = new PartnerDestination("partnerDestination", PartnerDestinationArgs.builder()
 *             .endpointBaseUrl("https://www.example/endpoint")
 *             .endpointServiceContext("This is an example")
 *             .expirationTimeIfNotActivatedUtc("2022-03-14T19:33:43.430Z")
 *             .location("westus2")
 *             .messageForActivation("Sample Activation message")
 *             .partnerDestinationName("examplePartnerDestinationName1")
 *             .partnerRegistrationImmutableId("0bd70ee2-7d95-447e-ab1f-c4f320019404")
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerDestination examplePartnerDestinationName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerDestinations/{partnerDestinationName}
 * ```
 */
public class PartnerDestination internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PartnerDestination,
) : KotlinCustomResource(javaResource, PartnerDestinationMapper) {
    /**
     * Activation state of the partner destination.
     */
    public val activationState: Output<String>?
        get() = javaResource.activationState().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint Base URL of the partner destination
     */
    public val endpointBaseUrl: Output<String>?
        get() = javaResource.endpointBaseUrl().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint context associated with this partner destination.
     */
    public val endpointServiceContext: Output<String>?
        get() = javaResource.endpointServiceContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Expiration time of the partner destination. If this timer expires and the partner destination was never activated,
     * the partner destination and corresponding channel are deleted.
     */
    public val expirationTimeIfNotActivatedUtc: Output<String>?
        get() = javaResource.expirationTimeIfNotActivatedUtc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Context or helpful message that can be used during the approval process.
     */
    public val messageForActivation: Output<String>?
        get() = javaResource.messageForActivation().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The immutable Id of the corresponding partner registration.
     */
    public val partnerRegistrationImmutableId: Output<String>?
        get() = javaResource.partnerRegistrationImmutableId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the partner destination.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to Partner Destination resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PartnerDestinationMapper : ResourceMapper<PartnerDestination> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PartnerDestination::class == javaResource::class

    override fun map(javaResource: Resource): PartnerDestination = PartnerDestination(
        javaResource as
            com.pulumi.azurenative.eventgrid.PartnerDestination,
    )
}

/**
 * @see [PartnerDestination].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PartnerDestination].
 */
public suspend fun partnerDestination(
    name: String,
    block: suspend PartnerDestinationResourceBuilder.() -> Unit,
): PartnerDestination {
    val builder = PartnerDestinationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PartnerDestination].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partnerDestination(name: String): PartnerDestination {
    val builder = PartnerDestinationResourceBuilder()
    builder.name(name)
    return builder.build()
}
