@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.eventgrid.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [PartnerRegistration].
 */
@PulumiTagMarker
public class PartnerRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PartnerRegistrationArgs = PartnerRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PartnerRegistrationArgsBuilder.() -> Unit) {
        val builder = PartnerRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): PartnerRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.eventgrid.PartnerRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return PartnerRegistration(builtJavaResource)
    }
}

/**
 * Information about a partner registration.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-06-01-preview.
 * Other available API versions: 2021-10-15-preview, 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerRegistrations_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerRegistration = new AzureNative.EventGrid.PartnerRegistration("partnerRegistration", new()
 *     {
 *         Location = "global",
 *         PartnerRegistrationName = "examplePartnerRegistrationName1",
 *         ResourceGroupName = "examplerg",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "Value2" },
 *             { "key3", "Value3" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerRegistration(ctx, "partnerRegistration", &eventgrid.PartnerRegistrationArgs{
 * 			Location:                pulumi.String("global"),
 * 			PartnerRegistrationName: pulumi.String("examplePartnerRegistrationName1"),
 * 			ResourceGroupName:       pulumi.String("examplerg"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("Value2"),
 * 				"key3": pulumi.String("Value3"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerRegistration;
 * import com.pulumi.azurenative.eventgrid.PartnerRegistrationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerRegistration = new PartnerRegistration("partnerRegistration", PartnerRegistrationArgs.builder()
 *             .location("global")
 *             .partnerRegistrationName("examplePartnerRegistrationName1")
 *             .resourceGroupName("examplerg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "Value2"),
 *                 Map.entry("key3", "Value3")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerRegistration examplePartnerRegistrationName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerRegistrations/{partnerRegistrationName}
 * ```
 */
public class PartnerRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.eventgrid.PartnerRegistration,
) : KotlinCustomResource(javaResource, PartnerRegistrationMapper) {
    /**
     * Location of the resource.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Name of the resource.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The immutableId of the corresponding partner registration.
     * Note: This property is marked for deprecation and is not supported in any future GA API version
     */
    public val partnerRegistrationImmutableId: Output<String>?
        get() = javaResource.partnerRegistrationImmutableId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Provisioning state of the partner registration.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * The system metadata relating to Partner Registration resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Tags of the resource.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Type of the resource.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object PartnerRegistrationMapper : ResourceMapper<PartnerRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.eventgrid.PartnerRegistration::class == javaResource::class

    override fun map(javaResource: Resource): PartnerRegistration = PartnerRegistration(
        javaResource
            as com.pulumi.azurenative.eventgrid.PartnerRegistration,
    )
}

/**
 * @see [PartnerRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [PartnerRegistration].
 */
public suspend fun partnerRegistration(
    name: String,
    block: suspend PartnerRegistrationResourceBuilder.() -> Unit,
): PartnerRegistration {
    val builder = PartnerRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [PartnerRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun partnerRegistration(name: String): PartnerRegistration {
    val builder = PartnerRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
