@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PartnerTopicArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.PartnerTopicActivationState
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventTypeInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.EventTypeInfoArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.IdentityInfoArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Event Grid Partner Topic.
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2021-10-15-preview.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PartnerTopics_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var partnerTopic = new AzureNative.EventGrid.PartnerTopic("partnerTopic", new()
 *     {
 *         ExpirationTimeIfNotActivatedUtc = "2022-03-23T23:06:13.109Z",
 *         Location = "westus2",
 *         MessageForActivation = "Example message for activation",
 *         PartnerRegistrationImmutableId = "6f541064-031d-4cc8-9ec3-a3b4fc0f7185",
 *         PartnerTopicFriendlyDescription = "Example description",
 *         PartnerTopicName = "examplePartnerTopicName1",
 *         ResourceGroupName = "examplerg",
 *         Source = "ContosoCorp.Accounts.User1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPartnerTopic(ctx, "partnerTopic", &eventgrid.PartnerTopicArgs{
 * 			ExpirationTimeIfNotActivatedUtc: pulumi.String("2022-03-23T23:06:13.109Z"),
 * 			Location:                        pulumi.String("westus2"),
 * 			MessageForActivation:            pulumi.String("Example message for activation"),
 * 			PartnerRegistrationImmutableId:  pulumi.String("6f541064-031d-4cc8-9ec3-a3b4fc0f7185"),
 * 			PartnerTopicFriendlyDescription: pulumi.String("Example description"),
 * 			PartnerTopicName:                pulumi.String("examplePartnerTopicName1"),
 * 			ResourceGroupName:               pulumi.String("examplerg"),
 * 			Source:                          pulumi.String("ContosoCorp.Accounts.User1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PartnerTopic;
 * import com.pulumi.azurenative.eventgrid.PartnerTopicArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var partnerTopic = new PartnerTopic("partnerTopic", PartnerTopicArgs.builder()
 *             .expirationTimeIfNotActivatedUtc("2022-03-23T23:06:13.109Z")
 *             .location("westus2")
 *             .messageForActivation("Example message for activation")
 *             .partnerRegistrationImmutableId("6f541064-031d-4cc8-9ec3-a3b4fc0f7185")
 *             .partnerTopicFriendlyDescription("Example description")
 *             .partnerTopicName("examplePartnerTopicName1")
 *             .resourceGroupName("examplerg")
 *             .source("ContosoCorp.Accounts.User1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PartnerTopic examplePartnerTopicName1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/partnerTopics/{partnerTopicName}
 * ```
 * @property activationState Activation state of the partner topic.
 * @property eventTypeInfo Event Type information from the corresponding event channel.
 * @property expirationTimeIfNotActivatedUtc Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
 * the partner topic and corresponding event channel are deleted.
 * @property identity Identity information for the Partner Topic resource.
 * @property location Location of the resource.
 * @property messageForActivation Context or helpful message that can be used during the approval process by the subscriber.
 * @property partnerRegistrationImmutableId The immutableId of the corresponding partner registration.
 * @property partnerTopicFriendlyDescription Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
 * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
 * @property partnerTopicName Name of the partner topic.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 * @property source Source associated with this partner topic. This represents a unique partner resource.
 * @property tags Tags of the resource.
 */
public data class PartnerTopicArgs(
    public val activationState: Output<Either<String, PartnerTopicActivationState>>? = null,
    public val eventTypeInfo: Output<EventTypeInfoArgs>? = null,
    public val expirationTimeIfNotActivatedUtc: Output<String>? = null,
    public val identity: Output<IdentityInfoArgs>? = null,
    public val location: Output<String>? = null,
    public val messageForActivation: Output<String>? = null,
    public val partnerRegistrationImmutableId: Output<String>? = null,
    public val partnerTopicFriendlyDescription: Output<String>? = null,
    public val partnerTopicName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val source: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PartnerTopicArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PartnerTopicArgs =
        com.pulumi.azurenative.eventgrid.PartnerTopicArgs.builder()
            .activationState(
                activationState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .eventTypeInfo(eventTypeInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .expirationTimeIfNotActivatedUtc(expirationTimeIfNotActivatedUtc?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .messageForActivation(messageForActivation?.applyValue({ args0 -> args0 }))
            .partnerRegistrationImmutableId(partnerRegistrationImmutableId?.applyValue({ args0 -> args0 }))
            .partnerTopicFriendlyDescription(partnerTopicFriendlyDescription?.applyValue({ args0 -> args0 }))
            .partnerTopicName(partnerTopicName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .source(source?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [PartnerTopicArgs].
 */
@PulumiTagMarker
public class PartnerTopicArgsBuilder internal constructor() {
    private var activationState: Output<Either<String, PartnerTopicActivationState>>? = null

    private var eventTypeInfo: Output<EventTypeInfoArgs>? = null

    private var expirationTimeIfNotActivatedUtc: Output<String>? = null

    private var identity: Output<IdentityInfoArgs>? = null

    private var location: Output<String>? = null

    private var messageForActivation: Output<String>? = null

    private var partnerRegistrationImmutableId: Output<String>? = null

    private var partnerTopicFriendlyDescription: Output<String>? = null

    private var partnerTopicName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var source: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Activation state of the partner topic.
     */
    @JvmName("mkhxwgyxxoawhted")
    public suspend fun activationState(`value`: Output<Either<String, PartnerTopicActivationState>>) {
        this.activationState = value
    }

    /**
     * @param value Event Type information from the corresponding event channel.
     */
    @JvmName("xqmyaiichuprvoos")
    public suspend fun eventTypeInfo(`value`: Output<EventTypeInfoArgs>) {
        this.eventTypeInfo = value
    }

    /**
     * @param value Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     */
    @JvmName("lrmanlhvnafgsalk")
    public suspend fun expirationTimeIfNotActivatedUtc(`value`: Output<String>) {
        this.expirationTimeIfNotActivatedUtc = value
    }

    /**
     * @param value Identity information for the Partner Topic resource.
     */
    @JvmName("kfjdxdtftuppyhfv")
    public suspend fun identity(`value`: Output<IdentityInfoArgs>) {
        this.identity = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("tqhrcfhpkkskgppe")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Context or helpful message that can be used during the approval process by the subscriber.
     */
    @JvmName("hchywxwrdbebskmw")
    public suspend fun messageForActivation(`value`: Output<String>) {
        this.messageForActivation = value
    }

    /**
     * @param value The immutableId of the corresponding partner registration.
     */
    @JvmName("hfsiyhbhcyplkpcu")
    public suspend fun partnerRegistrationImmutableId(`value`: Output<String>) {
        this.partnerRegistrationImmutableId = value
    }

    /**
     * @param value Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     */
    @JvmName("bvtgxxhbodfptidm")
    public suspend fun partnerTopicFriendlyDescription(`value`: Output<String>) {
        this.partnerTopicFriendlyDescription = value
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("nwkwtkfmuvpeufax")
    public suspend fun partnerTopicName(`value`: Output<String>) {
        this.partnerTopicName = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("pnksgmhsdlqmoteu")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Source associated with this partner topic. This represents a unique partner resource.
     */
    @JvmName("sopmkmewpceudbqm")
    public suspend fun source(`value`: Output<String>) {
        this.source = value
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("bqrkpndpsalebxat")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Activation state of the partner topic.
     */
    @JvmName("fyyrcqkyyutkqmxv")
    public suspend fun activationState(`value`: Either<String, PartnerTopicActivationState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Activation state of the partner topic.
     */
    @JvmName("nttsvxiirlscnlbs")
    public fun activationState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PartnerTopicActivationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Activation state of the partner topic.
     */
    @JvmName("pjfihjrqmeusnppm")
    public fun activationState(`value`: PartnerTopicActivationState) {
        val toBeMapped = Either.ofRight<String, PartnerTopicActivationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activationState = mapped
    }

    /**
     * @param value Event Type information from the corresponding event channel.
     */
    @JvmName("abpnqjgqdljwitfd")
    public suspend fun eventTypeInfo(`value`: EventTypeInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eventTypeInfo = mapped
    }

    /**
     * @param argument Event Type information from the corresponding event channel.
     */
    @JvmName("hamffarehascfhsq")
    public suspend fun eventTypeInfo(argument: suspend EventTypeInfoArgsBuilder.() -> Unit) {
        val toBeMapped = EventTypeInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.eventTypeInfo = mapped
    }

    /**
     * @param value Expiration time of the partner topic. If this timer expires while the partner topic is still never activated,
     * the partner topic and corresponding event channel are deleted.
     */
    @JvmName("qlriniinskvxaefw")
    public suspend fun expirationTimeIfNotActivatedUtc(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expirationTimeIfNotActivatedUtc = mapped
    }

    /**
     * @param value Identity information for the Partner Topic resource.
     */
    @JvmName("tcqffrnkhyrmlioe")
    public suspend fun identity(`value`: IdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity information for the Partner Topic resource.
     */
    @JvmName("qqjjcbkfquosuwlt")
    public suspend fun identity(argument: suspend IdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("fdwsepvactrjghpm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Context or helpful message that can be used during the approval process by the subscriber.
     */
    @JvmName("xttpxrsguvkvdclc")
    public suspend fun messageForActivation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageForActivation = mapped
    }

    /**
     * @param value The immutableId of the corresponding partner registration.
     */
    @JvmName("isbxsfvcoxewlotd")
    public suspend fun partnerRegistrationImmutableId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerRegistrationImmutableId = mapped
    }

    /**
     * @param value Friendly description about the topic. This can be set by the publisher/partner to show custom description for the customer partner topic.
     * This will be helpful to remove any ambiguity of the origin of creation of the partner topic for the customer.
     */
    @JvmName("jfhjgvywophfcgmc")
    public suspend fun partnerTopicFriendlyDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerTopicFriendlyDescription = mapped
    }

    /**
     * @param value Name of the partner topic.
     */
    @JvmName("nanndvtghjlysona")
    public suspend fun partnerTopicName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerTopicName = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("nqcgrdxdrkgfoewa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Source associated with this partner topic. This represents a unique partner resource.
     */
    @JvmName("sopydvmrtyvksbgf")
    public suspend fun source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Tags of the resource.
     */
    @JvmName("edbrqbtxumqmynwi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Tags of the resource.
     */
    @JvmName("aqckjbmcfmnoadyr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PartnerTopicArgs = PartnerTopicArgs(
        activationState = activationState,
        eventTypeInfo = eventTypeInfo,
        expirationTimeIfNotActivatedUtc = expirationTimeIfNotActivatedUtc,
        identity = identity,
        location = location,
        messageForActivation = messageForActivation,
        partnerRegistrationImmutableId = partnerRegistrationImmutableId,
        partnerTopicFriendlyDescription = partnerTopicFriendlyDescription,
        partnerTopicName = partnerTopicName,
        resourceGroupName = resourceGroupName,
        source = source,
        tags = tags,
    )
}
