@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.eventgrid.kotlin

import com.pulumi.azurenative.eventgrid.PrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.eventgrid.kotlin.enums.ResourceProvisioningState
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ConnectionStateArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.ConnectionStateArgsBuilder
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PrivateEndpointArgs
import com.pulumi.azurenative.eventgrid.kotlin.inputs.PrivateEndpointArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * Azure REST API version: 2022-06-15. Prior API version in Azure Native 1.x: 2020-06-01.
 * Other available API versions: 2023-06-01-preview, 2023-12-15-preview.
 * ## Example Usage
 * ### PrivateEndpointConnections_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var privateEndpointConnection = new AzureNative.EventGrid.PrivateEndpointConnection("privateEndpointConnection", new()
 *     {
 *         ParentName = "exampletopic1",
 *         ParentType = "topics",
 *         PrivateEndpointConnectionName = "BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B",
 *         PrivateLinkServiceConnectionState = new AzureNative.EventGrid.Inputs.ConnectionStateArgs
 *         {
 *             ActionsRequired = "None",
 *             Description = "approving connection",
 *             Status = "Approved",
 *         },
 *         ResourceGroupName = "examplerg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/eventgrid/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eventgrid.NewPrivateEndpointConnection(ctx, "privateEndpointConnection", &eventgrid.PrivateEndpointConnectionArgs{
 * 			ParentName:                    pulumi.String("exampletopic1"),
 * 			ParentType:                    pulumi.String("topics"),
 * 			PrivateEndpointConnectionName: pulumi.String("BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B"),
 * 			PrivateLinkServiceConnectionState: &eventgrid.ConnectionStateArgs{
 * 				ActionsRequired: pulumi.String("None"),
 * 				Description:     pulumi.String("approving connection"),
 * 				Status:          pulumi.String("Approved"),
 * 			},
 * 			ResourceGroupName: pulumi.String("examplerg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.eventgrid.PrivateEndpointConnection;
 * import com.pulumi.azurenative.eventgrid.PrivateEndpointConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var privateEndpointConnection = new PrivateEndpointConnection("privateEndpointConnection", PrivateEndpointConnectionArgs.builder()
 *             .parentName("exampletopic1")
 *             .parentType("topics")
 *             .privateEndpointConnectionName("BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B")
 *             .privateLinkServiceConnectionState(Map.ofEntries(
 *                 Map.entry("actionsRequired", "None"),
 *                 Map.entry("description", "approving connection"),
 *                 Map.entry("status", "Approved")
 *             ))
 *             .resourceGroupName("examplerg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:eventgrid:PrivateEndpointConnection BMTPE5.8A30D251-4C61-489D-A1AA-B37C4A329B8B /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.EventGrid/{parentType}/{parentName}/privateEndpointConnections/{privateEndpointConnectionName}
 * ```
 * @property groupIds GroupIds from the private link service resource.
 * @property parentName The name of the parent resource (namely, either, the topic name, domain name, or partner namespace name).
 * @property parentType The type of the parent resource. This can be either \'topics\', \'domains\', or \'partnerNamespaces\'.
 * @property privateEndpoint The Private Endpoint resource for this Connection.
 * @property privateEndpointConnectionName The name of the private endpoint connection connection.
 * @property privateLinkServiceConnectionState Details about the state of the connection.
 * @property provisioningState Provisioning state of the Private Endpoint Connection.
 * @property resourceGroupName The name of the resource group within the user's subscription.
 */
public data class PrivateEndpointConnectionArgs(
    public val groupIds: Output<List<String>>? = null,
    public val parentName: Output<String>? = null,
    public val parentType: Output<String>? = null,
    public val privateEndpoint: Output<PrivateEndpointArgs>? = null,
    public val privateEndpointConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null,
    public val provisioningState: Output<Either<String, ResourceProvisioningState>>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.eventgrid.PrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.eventgrid.PrivateEndpointConnectionArgs =
        com.pulumi.azurenative.eventgrid.PrivateEndpointConnectionArgs.builder()
            .groupIds(groupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .parentName(parentName?.applyValue({ args0 -> args0 }))
            .parentType(parentType?.applyValue({ args0 -> args0 }))
            .privateEndpoint(privateEndpoint?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .privateEndpointConnectionName(privateEndpointConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .provisioningState(
                provisioningState?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionArgsBuilder internal constructor() {
    private var groupIds: Output<List<String>>? = null

    private var parentName: Output<String>? = null

    private var parentType: Output<String>? = null

    private var privateEndpoint: Output<PrivateEndpointArgs>? = null

    private var privateEndpointConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<ConnectionStateArgs>? = null

    private var provisioningState: Output<Either<String, ResourceProvisioningState>>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("aaonkutgcuemleaa")
    public suspend fun groupIds(`value`: Output<List<String>>) {
        this.groupIds = value
    }

    @JvmName("ltsbuvofswvuakkh")
    public suspend fun groupIds(vararg values: Output<String>) {
        this.groupIds = Output.all(values.asList())
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("uoxdlqlsnmpvxrxh")
    public suspend fun groupIds(values: List<Output<String>>) {
        this.groupIds = Output.all(values)
    }

    /**
     * @param value The name of the parent resource (namely, either, the topic name, domain name, or partner namespace name).
     */
    @JvmName("mciljcxaxcqbotby")
    public suspend fun parentName(`value`: Output<String>) {
        this.parentName = value
    }

    /**
     * @param value The type of the parent resource. This can be either \'topics\', \'domains\', or \'partnerNamespaces\'.
     */
    @JvmName("hreyqanrcdkmigmb")
    public suspend fun parentType(`value`: Output<String>) {
        this.parentType = value
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("egdxdsoxgaronpbq")
    public suspend fun privateEndpoint(`value`: Output<PrivateEndpointArgs>) {
        this.privateEndpoint = value
    }

    /**
     * @param value The name of the private endpoint connection connection.
     */
    @JvmName("wvasiphamximtnbl")
    public suspend fun privateEndpointConnectionName(`value`: Output<String>) {
        this.privateEndpointConnectionName = value
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("ooqkjtekvgrxnsgh")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<ConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("sogxuvunlftdehnf")
    public suspend fun provisioningState(`value`: Output<Either<String, ResourceProvisioningState>>) {
        this.provisioningState = value
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("qsxgxwbogrlbricp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value GroupIds from the private link service resource.
     */
    @JvmName("bcyqexurwsatouxe")
    public suspend fun groupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param values GroupIds from the private link service resource.
     */
    @JvmName("coivcrculddbcxoj")
    public suspend fun groupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupIds = mapped
    }

    /**
     * @param value The name of the parent resource (namely, either, the topic name, domain name, or partner namespace name).
     */
    @JvmName("lomyweorsrxsnaam")
    public suspend fun parentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentName = mapped
    }

    /**
     * @param value The type of the parent resource. This can be either \'topics\', \'domains\', or \'partnerNamespaces\'.
     */
    @JvmName("oouqyqpuuvwwrnei")
    public suspend fun parentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentType = mapped
    }

    /**
     * @param value The Private Endpoint resource for this Connection.
     */
    @JvmName("pgywwnvatvweecip")
    public suspend fun privateEndpoint(`value`: PrivateEndpointArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpoint = mapped
    }

    /**
     * @param argument The Private Endpoint resource for this Connection.
     */
    @JvmName("uotjorukglnpibob")
    public suspend fun privateEndpoint(argument: suspend PrivateEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateEndpointArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateEndpoint = mapped
    }

    /**
     * @param value The name of the private endpoint connection connection.
     */
    @JvmName("lquxisqtwucgnvfq")
    public suspend fun privateEndpointConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value Details about the state of the connection.
     */
    @JvmName("sjtwwmxlusavutth")
    public suspend fun privateLinkServiceConnectionState(`value`: ConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument Details about the state of the connection.
     */
    @JvmName("uiolrknxnihlsxqu")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend ConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionStateArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("ckhmfqvofmmgthbw")
    public suspend fun provisioningState(`value`: Either<String, ResourceProvisioningState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("xwxejqrdsjxfhegr")
    public fun provisioningState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value Provisioning state of the Private Endpoint Connection.
     */
    @JvmName("wxnqtecbogsqewoq")
    public fun provisioningState(`value`: ResourceProvisioningState) {
        val toBeMapped = Either.ofRight<String, ResourceProvisioningState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provisioningState = mapped
    }

    /**
     * @param value The name of the resource group within the user's subscription.
     */
    @JvmName("uldcarvrkakhdgvs")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): PrivateEndpointConnectionArgs = PrivateEndpointConnectionArgs(
        groupIds = groupIds,
        parentName = parentName,
        parentType = parentType,
        privateEndpoint = privateEndpoint,
        privateEndpointConnectionName = privateEndpointConnectionName,
        privateLinkServiceConnectionState = privateLinkServiceConnectionState,
        provisioningState = provisioningState,
        resourceGroupName = resourceGroupName,
    )
}
